/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcag2;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.wcag2.Alertion;
import com.trs.wcag2.validator.BiTagValidator;
import com.trs.wcag2.validator.DocTypeValidator;
import com.trs.wcag2.validator.EmbedAltValidator;
import com.trs.wcag2.validator.EventsValidator;
import com.trs.wcag2.validator.FormElementsValidator;
import com.trs.wcag2.validator.FormSubmitValidator;
import com.trs.wcag2.validator.FrameTitleValidator;
import com.trs.wcag2.validator.HtmlCharsetValidator;
import com.trs.wcag2.validator.HtmlH1Validator;
import com.trs.wcag2.validator.HtmlH1_H6Validator;
import com.trs.wcag2.validator.HtmlLangValidator;
import com.trs.wcag2.validator.HtmlTitleValidator;
import com.trs.wcag2.validator.IValidator;
import com.trs.wcag2.validator.ImgAltValidator;
import com.trs.wcag2.validator.ObjectBodyValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class WCAG2Helper {
    private static List m_lstValidators = new ArrayList();

    private static List getAlertions(String content) {
        ArrayList<Alertion> lstAlertions = new ArrayList<Alertion>();
        HashMap known = new HashMap();
        for (IValidator vtor : m_lstValidators) {
            Object o = vtor.doValid(content, known);
            if (o == Boolean.TRUE || o == null) continue;
            if (o instanceof HashMap) {
                HashMap mp = (HashMap)o;
                for (String key : mp.keySet()) {
                    WCAG2Helper.arrAlertions((List)mp.get(key), lstAlertions, vtor, key);
                }
                continue;
            }
            if (o instanceof List) {
                WCAG2Helper.arrAlertions((List)o, lstAlertions, vtor, null);
                continue;
            }
            Alertion alertion = new Alertion();
            alertion.setHTML("");
            alertion.setKlass(vtor.getType());
            alertion.setWarning(vtor.getWarning(o));
            alertion.setLevel(Alertion.FAIL);
            alertion.setNum(1);
            alertion.setExample(vtor.getExample(o));
            lstAlertions.add(alertion);
        }
        return lstAlertions;
    }

    private static void arrAlertions(List rst, List lstAlertions, IValidator vtor, String key) {
        if (rst.size() == 0) {
            return;
        }
        Alertion alertion = new Alertion();
        alertion.setRst(rst);
        alertion.setHTML(WCAG2Helper.getWarnHTML(rst));
        alertion.setKlass(vtor.getType());
        alertion.setWarning(vtor.getWarning(key));
        alertion.setExample(vtor.getExample(key));
        alertion.setLevel("warn".equalsIgnoreCase(key) ? Alertion.WARN : Alertion.FAIL);
        alertion.setNum(rst.size());
        lstAlertions.add(alertion);
    }

    private static String getWarnHTML(List rst) {
        StringBuffer sbRst = new StringBuffer();
        boolean isFirst = true;
        String sep = "\n";
        Iterator iterator = rst.iterator();
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sbRst.append(sep);
            }
            Object str = iterator.next();
            if (str instanceof String) {
                sbRst.append(str);
                continue;
            }
            if (!(str instanceof String[])) continue;
            String[] arr = (String[])str;
            sbRst.append(I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label1", "\u7b2c") + arr[0] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label2", "\u884c,\u7b2c") + arr[1] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label3", "\u5217:") + arr[2]);
        }
        return sbRst.toString();
    }

    public static void registerValidator(IValidator o) {
        m_lstValidators.add(o);
    }

    public static Object doValid(String content) {
        List alertions = WCAG2Helper.getAlertions(content);
        return alertions;
    }

    public static void main(String[] args) {
        String html = "fas\nasdfasdf\nasdfsdf\n<html>as\nd\n<meta http-equiv='content' content='text/html'>\n fasd<title>abc</title>fasdf\nasdf<H1>ab</H1>asd\nasdf<A></A><IMG alt=\"asf\"><B onmouseover=aa>iiasdfs</b>sadf<I>asdfsfda</I>asdf<b>dfasd</b><A class=a-gray title='<TRS_DOCUMENT FIELD=\"DocTitle\"/>' href=\"http://www.nlc.gov.cn/syzt/2009/0304/article_224.htm\" target=_blank>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb</A>\ndasfasdf\n" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label4", "<IMG class=a-gray title=\"<TRS_DOCUMENT FIELD=\"DocTitle\"/>\" src=\"<TRS_DOCUMENT FIELD=\"_RECURL\"/>\" target=_blank/>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acbasdfasd\n") + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label5", "<A class=a-gray title=\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb href=\"http://www.nlc.gov.cn/syzt/2009/0304/article_224.htm\" target=_blank>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb</A>\n") + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label6", "af<INPUT id=aa><label for=aa></label><INPUT title=bb><BUTTON>fads</BUTTON>sadfsad\n<A class=a-gray title=\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb  asdf='<\\'>' href=\"http://www.nlc.gov.cn/syzt/2009/0304/article_224.htm\" target=_blank>\u56fd\u9645\u56fe\u8054\u4e2d\u6587\u8bed\u8a00\u4e2d\u5fc3\u5728\u6211\u9986\u6210\u7acb</A>\n") + "<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0\" width=\"404\" height=\"111\">\n<param name=\"movie\" value=\"service/swf/head.swf\" />\n<param name=\"quality\" value=\"high\" />\n<embed src=\"service/swf/head.swf\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"404\" height=\"111\"></embed>\n</object></html>";
        try {
            html = CMyFile.readFile("C:\\1.txt", "utf-8");
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        WCAG2Helper.doValid(html);
    }

    public static String toHTML(List alertions) {
        if (alertions.size() == 0) {
            return I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label7", "<REPORT><IS_SUCCESS>true</IS_SUCCESS><TITLE><![CDATA[\u65e0\u969c\u788d\u68c0\u67e5\u7ed3\u679c:\u7b26\u5408WCAG2\u89c4\u8303!]]></TITLE><TYPE>3</TYPE></REPORT>");
        }
        StringBuffer sbRst = new StringBuffer();
        sbRst.append("<ul>");
        String sIdPre = "sys_alertion_";
        String sId = null;
        for (int i = 0; i < alertions.size(); ++i) {
            Alertion alertion = (Alertion)alertions.get(i);
            sId = sIdPre + i;
            sbRst.append("<li>");
            sbRst.append("<span class=\"accessibility_level\">");
            sbRst.append(alertion.getLevel());
            sbRst.append("</span>");
            sbRst.append("<span class=\"accessibility_class\">");
            sbRst.append(alertion.getKlass());
            sbRst.append("</span>");
            sbRst.append("<span class=\"accessibility_warning\">");
            sbRst.append(alertion.getWarning());
            sbRst.append("</span>");
            sbRst.append("<a class=\"accessibility_detail\" href=\"#\" onclick=\"renderAccessibility('");
            sbRst.append(sId);
            sbRst.append("_example')\"" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label8", ">\u5efa\u8bae</a>"));
            sbRst.append("<span style=\"display:none;\" id=\"");
            sbRst.append(sId);
            sbRst.append("_example\">");
            sbRst.append(alertion.getExample());
            sbRst.append("</span>");
            List lstRst = alertion.getRst();
            if (lstRst == null) continue;
            sbRst.append("<span class=\"accessibility_num\">(");
            sbRst.append(alertion.getNum());
            sbRst.append(")</span>");
            sbRst.append("<a class=\"accessibility_detail\" href=\"#\" onclick=\"Element.toggle('");
            sbRst.append(sId);
            sbRst.append("')\"" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label9", ">\u8be6\u7ec6</a>"));
            sbRst.append("<table border=\"1\" bordercolor=\"gray\" style=\"display:none;\" id=\"");
            sbRst.append(sId);
            sbRst.append("\">");
            Iterator iterator = lstRst.iterator();
            while (iterator.hasNext()) {
                sbRst.append("<tr>");
                Object str = iterator.next();
                if (str instanceof String[]) {
                    String[] arr = (String[])str;
                    str = "<span class=\"accessibility_rowpos\"" + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label10", ">\u7b2c") + arr[0] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label2", "\u884c,\u7b2c") + arr[1] + I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label11", "\u5217</span>:") + CMyString.filterForHTMLValue(arr[2]);
                } else {
                    str = CMyString.filterForHTMLValue((String)str);
                }
                sbRst.append("<td>");
                sbRst.append(str.toString());
                sbRst.append("</td></tr>");
            }
            sbRst.append("</table>");
        }
        sbRst.append("</ul>");
        String rst = I18NMessage.get(WCAG2Helper.class, "WCAG2Helper.label12", "<REPORT><IS_SUCCESS>false</IS_SUCCESS><TITLE><![CDATA[\u65e0\u969c\u788d\u68c0\u67e5\u7ed3\u679c:]]></TITLE><ERROR_INFO><![CDATA[ ") + sbRst.toString() + "]]></ERROR_INFO><TYPE>5</TYPE></REPORT>";
        return rst;
    }

    static {
        WCAG2Helper.registerValidator(new DocTypeValidator());
        WCAG2Helper.registerValidator(new HtmlLangValidator());
        WCAG2Helper.registerValidator(new HtmlCharsetValidator());
        WCAG2Helper.registerValidator(new HtmlTitleValidator());
        WCAG2Helper.registerValidator(new HtmlH1Validator());
        WCAG2Helper.registerValidator(new HtmlH1_H6Validator());
        WCAG2Helper.registerValidator(new ImgAltValidator());
        WCAG2Helper.registerValidator(new BiTagValidator());
        WCAG2Helper.registerValidator(new FrameTitleValidator());
        WCAG2Helper.registerValidator(new ObjectBodyValidator());
        WCAG2Helper.registerValidator(new EmbedAltValidator());
        WCAG2Helper.registerValidator(new FormSubmitValidator());
        WCAG2Helper.registerValidator(new FormElementsValidator());
        WCAG2Helper.registerValidator(new EventsValidator());
    }
}

