/*
 * Decompiled with CFR 0.152.
 */
package com.trs.presentation.nav;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.WCMDiscoveryFactory;
import com.trs.presentation.nav.INavHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class NavHandlerFactory {
    private static Logger logger = Logger.getLogger(NavHandlerFactory.class);
    private static Map handlerMap = null;

    private static synchronized void init() throws WCMException {
        if (handlerMap != null) {
            return;
        }
        HashMap<String, String> tempMap = new HashMap<String, String>(3);
        Iterator itCreators = WCMDiscoveryFactory.getDiscovery().getImplementors(INavHandler.class.getName());
        while (itCreators.hasNext()) {
            String sHandlerClassName = (String)itCreators.next();
            try {
                INavHandler handler = (INavHandler)Class.forName(sHandlerClassName).newInstance();
                tempMap.put(handler.toHandlerkey().toLowerCase(), sHandlerClassName);
            }
            catch (Throwable e) {
                String sErrorInfo = I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label1", "\u6ce8\u518c\u5bfc\u822a\u6784\u9020\u5668[ClassName=") + sHandlerClassName + I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label2", "]\u5931\u8d25\uff01");
                logger.error((Object)sErrorInfo, e);
                throw new WCMException(sErrorInfo, e);
            }
        }
        handlerMap = tempMap;
    }

    public static INavHandler getNavHandler(String _sItemKey) throws WCMException {
        String sHandlerClassName;
        if (handlerMap == null) {
            NavHandlerFactory.init();
        }
        if ((sHandlerClassName = (String)handlerMap.get(_sItemKey.toLowerCase())) == null) {
            throw new WCMException(I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684Handler\uff01(Key=") + _sItemKey + ")");
        }
        try {
            return (INavHandler)Class.forName(sHandlerClassName).newInstance();
        }
        catch (Throwable e) {
            throw new WCMException(I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label1", "\u6ce8\u518c\u5bfc\u822a\u6784\u9020\u5668[ClassName=") + sHandlerClassName + I18NMessage.get(NavHandlerFactory.class, "NavHandlerFactory.label2", "]\u5931\u8d25\uff01"), e);
        }
    }
}

