/*
 * Decompiled with CFR 0.152.
 */
package com.trs.mas;

import com.trs.cms.content.CMSObj;
import com.trs.cms.content.DefaultObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParserCMSObjBase;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.metadata.publish.PublishContentViewDataImpl;
import com.trs.components.video.VSConfig;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.DebugTimer;
import com.trs.mas.MediaHelper;
import com.trs.util.CMyString;
import java.util.Iterator;
import java.util.Map;
import org.apache.batik.dom.util.HashTable;
import org.apache.log4j.Logger;

public class TagParserForMAS
extends TagParserCMSObjBase {
    private static Logger logger = Logger.getLogger(TagParserForMAS.class);

    @Override
    public TagBeanInfo getBeanInfo() {
        return null;
    }

    @Override
    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        Integer iObjectKey;
        Object oValue;
        DefaultObj oMASObj;
        if (_context.getUpperHost().getSubstance() instanceof DefaultObj && (oMASObj = (DefaultObj)_context.getUpperHost().getSubstance()).containsProperty("masId")) {
            return oMASObj;
        }
        int nMasId = _context.getAttribute("ID", 0);
        if (nMasId <= 0) {
            logger.warn((Object)("TRS_MAS\u89e3\u6790\u4e0d\u7b26\u5408\u9884\u671f\uff01\u53ef\u80fd\u662f\u4e0a\u4e0b\u6587\u5bf9\u8c61\u6ca1\u6709\u8bb0\u5f55MasId\uff1f\n\u4e0a\u4e0b\u6587\u5bf9\u8c61:[Class=" + _context.getUpperHost().getClass().getName() + "][ID=" + _context.getUpperHost().getId() + "]\n\u8bb0\u5f55\u7684ID\u4fe1\u606f\u4e3a[" + _context.getAttribute("ID") + "]"));
            return null;
        }
        HashTable hMasObjects = (HashTable)_context.getPageContext().getTaskContext().getCachObject("MASObjects");
        if (hMasObjects == null) {
            hMasObjects = new HashTable();
            _context.getPageContext().getTaskContext().putInCache("MASObjects", hMasObjects);
        }
        if ((oValue = hMasObjects.get((Object)(iObjectKey = new Integer(nMasId)))) != null) {
            return (DefaultObj)oValue;
        }
        Map hMediaInfo = this.getMediaInfo(_context, nMasId);
        if (hMediaInfo == null) {
            return null;
        }
        DefaultObj oDefaultObj = new DefaultObj();
        Iterator itKeys = hMediaInfo.keySet().iterator();
        while (itKeys.hasNext()) {
            String sKey = itKeys.next().toString();
            oDefaultObj.setProperty(sKey.toUpperCase(), hMediaInfo.get(sKey), false);
        }
        oDefaultObj.setAddMode(false);
        oDefaultObj.setId(nMasId);
        hMasObjects.put((Object)iObjectKey, (Object)oDefaultObj);
        return oDefaultObj;
    }

    private Map getMediaInfo(PublishTagContext _context, int _nMasId) throws WCMException {
        IPublishElement publishElement = _context.getUpperHost();
        if (!(publishElement instanceof PublishContentViewDataImpl) && !(publishElement instanceof PublishContentDocumentImpl)) {
            throw new WCMException(200006, "\u5f53\u524dUpperHost\u4e0d\u662fViewData\uff01");
        }
        int nDocId = publishElement.getSubstance().getId();
        int nMaxGetCount = _context.getAttribute("MaxGetCount", 4);
        int nMaxGetTime = _context.getAttribute("MaxGetTime", 600);
        String sVideoType = _context.getAttributeTrim("TYPE");
        if (CMyString.isEmpty((String)sVideoType)) {
            sVideoType = "vod";
        }
        logger.debug((Object)("TYPE" + sVideoType));
        Map hMediaInfo = null;
        String sMasURL = ConfigServer.getServer().getSysConfigValue("MAS_HOST_URL", "http://bbs.trs.net.cn/mas/openapi/pages.do");
        DebugTimer timer = new DebugTimer();
        boolean bSucccess = false;
        for (int i = 0; i < nMaxGetCount; ++i) {
            timer.start();
            try {
                hMediaInfo = MediaHelper.getMediaInfo(sMasURL, VSConfig.getAppKey(), _nMasId, sVideoType, String.valueOf(nDocId));
                timer.stop();
                if (timer.getTime() > (long)nMaxGetTime) {
                    logger.warn((Object)("Get the media[Id=" + _nMasId + "] info from MAS[" + sMasURL + "] use [" + timer.getTime() + "]ms!"));
                }
                return hMediaInfo;
            }
            catch (Exception e) {
                logger.error((Object)("Fail to get the media[Id=" + _nMasId + "] info from MAS[" + sMasURL + "]!"), (Throwable)e);
                timer.stop();
                logger.warn((Object)("Get[" + (i + 1) + "] the media[Id=" + _nMasId + "] info from MAS[" + sMasURL + "] use [" + timer.getTime() + "]ms!"));
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return null;
    }

    @Override
    protected String getAutoLinkUrl(PublishTagContext _context) throws WCMException {
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
    }

    @Override
    protected String[] parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) throws WCMException {
        return null;
    }
}

