/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.video.publish;

import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.video.VSConfig;
import com.trs.components.video.publish.TagUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class VideoLiveTagParser
extends BaseTagParser {
    private static final Logger LOG;
    private static final String FLEX_HEIGHT = "310";
    private static final String FLEX_WIDTH = "378";
    public static final String TAG_NAME = "TRS_VIDEO_LIVE";
    public static final String ATTR_LIVE_NAME = "LIVE_NAME";
    public static final String ATTR_LOGOALPHA = "LOGOALPHA";
    private TagBeanInfo tagBeanInfo = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.publish.VideoLiveTagParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public VideoLiveTagParser() {
        this.buildTagBeanInfo();
    }

    private void buildTagBeanInfo() {
        TagBeanInfo tbi = new TagBeanInfo();
        tbi.setName(TAG_NAME);
        tbi.setDesc(TAG_NAME);
        tbi.setType(TagBeanInfo.BodyType.IGNORE);
        TagBeanAttrInfo tbai = new TagBeanAttrInfo();
        tbai.setName(ATTR_LIVE_NAME);
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setDefaultValue("LiveTest");
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName(ATTR_LOGOALPHA);
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setDefaultValue("0.5");
        tbai.setEnumValue(new String[]{"0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1"});
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("OBJID");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setDefaultValue("player");
        tbi.addAttrInfo(tbai);
        tbai = new TagBeanAttrInfo();
        tbai.setName("DIVID");
        tbai.setType(TagBeanAttrInfo.Type.STRING);
        tbai.setDefaultValue("flashcontent");
        tbi.addAttrInfo(tbai);
        this.tagBeanInfo = tbi;
    }

    public TagBeanInfo getBeanInfo() {
        return this.tagBeanInfo;
    }

    public String[] parse(PublishTagContext _context) throws WCMException {
        String liveName = TagUtil.getAttrValue(_context, ATTR_LIVE_NAME, null);
        if (liveName == null) {
            StringBuffer stringBuffer = new StringBuffer(TAG_NAME);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.trs.components.video.publish.VideoLiveTagParser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new WCMException(stringBuffer.append(CMyString.format((String)I18NMessage.get((Class)clazz, (String)"VideoLiveTagParser.label1", (String)"\u7f6e\u6807\u7f3a\u5c11\u5fc5\u987b\u7684[{0}]\u5c5e\u6027!"), (String[])new String[]{ATTR_LIVE_NAME})).toString());
        }
        String objid = TagUtil.getAttrValue(_context, "OBJID", "player");
        String divId = TagUtil.getAttrValue(_context, "DIVID", "flashcontent");
        String logoAlpha = TagUtil.getAttrValue(_context, ATTR_LOGOALPHA, "0.5");
        String flvPlayerBase = TagUtil.getAttrValue(_context, "SWF_LOCATION", VSConfig.getFLVPlayerBase());
        String fmsAppUrl = TagUtil.getAttrValue(_context, "LIVE_FMSAPPURL", VSConfig.getRecordFMSAppUrl());
        String scripts = VideoLiveTagParser.generateVideoScriptsForV2(flvPlayerBase, fmsAppUrl, liveName, objid, FLEX_WIDTH, FLEX_HEIGHT, divId, logoAlpha);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("liveName=[" + liveName + "]"));
        }
        return new String[]{scripts};
    }

    static String generateVideoScriptsForV2(String flvPlayerBase, String fmsAppUrl, String liveName, String objId, String width, String height, String divId, String logoAlpha) {
        StringBuffer sb = new StringBuffer(128);
        StringBuffer stringBuffer = sb.append("<div id='").append(divId);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.components.video.publish.VideoLiveTagParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringBuffer.append(I18NMessage.get((Class)clazz, (String)"VideoLiveTagParser.label3", (String)"'>\u60a8\u7684\u6d4f\u89c8\u5668\u548cFlash\u73af\u5883\u5f02\u5e38, \u5bfc\u81f4\u8be5\u5185\u5bb9\u65e0\u6cd5\u663e\u793a!</div>"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.trs.components.video.publish.VideoLiveTagParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sb.append(I18NMessage.get((Class)clazz2, (String)"VideoLiveTagParser.label4", (String)"<noscript>\u60a8\u4f7f\u7528\u7684\u6d4f\u89c8\u5668\u4e0d\u652f\u6301\u6216\u6ca1\u6709\u542f\u7528javascript, \u8bf7\u542f\u7528javascript\u540e\u518d\u8bbf\u95ee!</noscript>"));
        sb.append("<script type='text/javascript' src='").append(flvPlayerBase).append("/js/opensource/swfobject.js' ></script>");
        sb.append("<script type='text/javascript'>");
        sb.append("var flashvars = {fmsAppUrl:'").append(fmsAppUrl).append("',");
        sb.append("live:'true',");
        sb.append("liveName:'").append(liveName).append("',");
        sb.append("logoAlpha:'").append(logoAlpha).append("'};");
        sb.append("var params = {allowFullScreen:'true',");
        sb.append("quality:'high',");
        sb.append("allowScriptAccess:'always'};");
        sb.append("var attributes = {};");
        sb.append("attributes.id = 'fCam';");
        sb.append("swfobject.embedSWF('").append(flvPlayerBase).append("TRSVideoPlayer.swf','").append(divId).append("',").append(width).append(",").append(height).append(",'9.0.124',false,flashvars,params,attributes);");
        sb.append("</script>");
        return sb.toString();
    }
}

