/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringHelper {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String KEYVALUE_SPLITTER = "=";
    public static final String PROPERTY_SPLITTER = "&";

    public static byte byteAt(String strHead, int index) {
        byte result = (byte)strHead.charAt(index);
        result = (byte)(result - 48);
        return result;
    }

    public static String[] split(String origin, String token) {
        if (StringHelper.isEmpty(origin)) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(origin, token);
        int countTokens = st.countTokens();
        if (countTokens <= 0) {
            return new String[]{origin};
        }
        String[] results = new String[countTokens];
        int i = 0;
        while (i < countTokens) {
            results[i] = st.nextToken();
            ++i;
        }
        return results;
    }

    public static String[] mergeArrary(String[] firstArray, String[] secondArray) {
        if (StringHelper.isStringArrayEmpty(firstArray) && StringHelper.isStringArrayEmpty(secondArray)) {
            return null;
        }
        if (StringHelper.isStringArrayEmpty(firstArray) && secondArray != null) {
            return secondArray;
        }
        if (firstArray != null && StringHelper.isStringArrayEmpty(secondArray)) {
            return firstArray;
        }
        int firstLength = firstArray.length;
        int secondLength = secondArray.length;
        int resultLength = firstLength + secondLength;
        String[] resultArray = new String[resultLength];
        int i = 0;
        while (i < firstLength) {
            resultArray[i] = firstArray[i];
            ++i;
        }
        int j = 0;
        while (j < secondLength) {
            resultArray[firstLength + j] = secondArray[j];
            ++j;
        }
        return resultArray;
    }

    public static boolean isStringArrayEmpty(String[] strArray) {
        return strArray == null || strArray.length == 0;
    }

    public static List splitToList(String origin, String token) {
        ArrayList<String> result = new ArrayList<String>();
        String[] arr = StringHelper.split(origin, token);
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                result.add(arr[i]);
                ++i;
            }
        }
        return result;
    }

    public static String[] splitAtFirstToken(String origin, String token) {
        if (StringHelper.isEmpty(origin)) {
            return null;
        }
        if (StringHelper.isEmpty(token)) {
            return new String[]{origin};
        }
        int firstTokenIndex = origin.indexOf(token, 0);
        if (firstTokenIndex == -1) {
            return new String[]{origin};
        }
        String firstString = origin.substring(0, firstTokenIndex);
        String secondString = origin.substring(firstTokenIndex + token.length(), origin.length());
        String[] arrayToReturn = new String[]{firstString, secondString};
        return arrayToReturn;
    }

    public static String reverse(String origin) {
        if (origin == null) {
            throw new NullPointerException("\u53c2\u6570\u4e3anull!");
        }
        return new StringBuffer(origin).reverse().toString();
    }

    public static String encodingByISO8859_1(String string) {
        if (string != null && !"".equals(string)) {
            try {
                return new String(string.getBytes(), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("\u8fdb\u884cISO-8859-1\u8f6c\u7801\u65f6\u51fa\u9519");
                e.printStackTrace();
                return string;
            }
        }
        return string;
    }

    public static String[] splitAlways(String origin, String token) {
        return StringHelper.split(origin, token);
    }

    public static String[] splitWithMutiChar(String origin, String token) {
        if (StringHelper.isEmpty(origin)) {
            return null;
        }
        if (StringHelper.isEmpty(token)) {
            return new String[]{origin};
        }
        if (token.length() == 1) {
            return StringHelper.split(origin, token);
        }
        int index = origin.indexOf(token);
        if (index < 0) {
            return new String[]{origin};
        }
        return origin.split(token);
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return "null!";
        }
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
            ++i;
        }
        return new String(out);
    }

    public static byte[] toBytes(String str) {
        if (str == null) {
            return null;
        }
        char[] data = str.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters!");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = StringHelper.toDigit(data[j], j) << 4;
            f |= StringHelper.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static String filterForHTMLValue(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        char[] srcBuff = _sContent.toCharArray();
        int nLen = srcBuff.length;
        if (nLen == 0) {
            return "";
        }
        StringBuffer retBuff = new StringBuffer((int)((double)nLen * 1.8));
        int i = 0;
        while (i < nLen) {
            char cTemp = srcBuff[i];
            switch (cTemp) {
                case '<': {
                    retBuff.append("&lt;");
                    break;
                }
                case '>': {
                    retBuff.append("&gt;");
                    break;
                }
                case '\"': {
                    retBuff.append("&quot;");
                    break;
                }
                default: {
                    retBuff.append(cTemp);
                }
            }
            ++i;
        }
        return retBuff.toString();
    }

    public static String antiFilterForHTMLValue(String _sContent) {
        if (_sContent == null) {
            return "";
        }
        _sContent = _sContent.replaceAll("&amp;", PROPERTY_SPLITTER);
        _sContent = _sContent.replaceAll("&lt;", "<");
        _sContent = _sContent.replaceAll("&gt;", ">");
        _sContent = _sContent.replaceAll("&quot;", "\"");
        return _sContent;
    }

    public static String toString(Object[] objs) {
        return StringHelper.toString(objs, false, ", ");
    }

    public static String toString(Object[] objs, boolean showOrder) {
        return StringHelper.toString(objs, showOrder, ",");
    }

    public static String toString(Object[] objs, boolean showOrder, String token) {
        if (objs == null) {
            return "null";
        }
        int len = objs.length;
        StringBuffer sb = new StringBuffer(10 * len);
        int i = 0;
        while (i < len) {
            if (showOrder) {
                sb.append(i).append(':');
            }
            sb.append(objs[i]);
            if (i < len - 1) {
                sb.append(token);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String avoidNull(String str) {
        if ("null".equals(str)) {
            return "";
        }
        return str == null ? "" : str;
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }

    static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal charcter " + ch + " at index " + index);
        }
        return digit;
    }

    public static String replaceWithRegex(String templateStr, Map<String, ?> data, Pattern pattern) {
        if (StringHelper.isEmpty(templateStr)) {
            return null;
        }
        if (data == null) {
            data = Collections.EMPTY_MAP;
        }
        StringBuffer newValue = new StringBuffer(templateStr.length());
        Matcher matcher = pattern.matcher(templateStr);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (data.get(key) == null) continue;
            String r = data.get(key).toString();
            matcher.appendReplacement(newValue, r.replaceAll("\\\\", "\\\\\\\\"));
        }
        matcher.appendTail(newValue);
        return newValue.toString();
    }

    public static String replaceStr(String _strSrc, String _strOld, String _strNew) {
        if (_strSrc == null) {
            return null;
        }
        char[] srcBuff = _strSrc.toCharArray();
        int nSrcLen = srcBuff.length;
        if (nSrcLen == 0) {
            return "";
        }
        char[] oldStrBuff = _strOld.toCharArray();
        int nOldStrLen = oldStrBuff.length;
        if (nOldStrLen == 0 || nOldStrLen > nSrcLen) {
            return _strSrc;
        }
        StringBuffer retBuff = new StringBuffer(nSrcLen * (1 + _strNew.length() / nOldStrLen));
        boolean bIsFound = false;
        int i = 0;
        while (i < nSrcLen) {
            bIsFound = false;
            if (srcBuff[i] == oldStrBuff[0]) {
                int j = 1;
                while (j < nOldStrLen) {
                    if (i + j >= nSrcLen || srcBuff[i + j] != oldStrBuff[j]) break;
                    ++j;
                }
                boolean bl = bIsFound = j == nOldStrLen;
            }
            if (bIsFound) {
                retBuff.append(_strNew);
                i += nOldStrLen;
                continue;
            }
            int nSkipTo = i + nOldStrLen >= nSrcLen ? nSrcLen - 1 : i;
            while (i <= nSkipTo) {
                retBuff.append(srcBuff[i]);
                ++i;
            }
        }
        srcBuff = null;
        oldStrBuff = null;
        return retBuff.toString();
    }

    public static String[] splitAndTrim(String origin, String token) {
        if (origin == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(origin = origin.trim(), token);
        int countTokens = st.countTokens();
        if (countTokens <= 0) {
            return new String[]{origin};
        }
        ArrayList<String> strs = new ArrayList<String>(countTokens);
        int i = 0;
        while (i < countTokens) {
            String str = st.nextToken().trim();
            if (str.length() > 0) {
                strs.add(str);
            }
            ++i;
        }
        return strs.toArray(new String[0]);
    }

    public static String hexToStr(String hex) {
        return new String(StringHelper.toBytes(hex));
    }

    public static String truncateAndTrim(String str, String delim) {
        if (str == null || delim == null) {
            return str;
        }
        int nStart = str.indexOf(delim);
        if (nStart < 0) {
            return str;
        }
        return str.substring(nStart + delim.length()).trim();
    }

    public static String getStringByEncoding(String originalStr, String encoding) {
        String encodingStr = originalStr;
        try {
            encodingStr = new String(originalStr.getBytes(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            return originalStr;
        }
        return encodingStr;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String adjustLength(String str, int maxLength) {
        if (str == null) {
            return str;
        }
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Illegal value of maxLength: " + maxLength + "! It must be a positive integer.");
        }
        int strLength = str.length();
        if (maxLength > strLength) {
            return str;
        }
        String DELIT = "...";
        StringBuffer sb = new StringBuffer(maxLength);
        int splitPos = (maxLength - "...".length()) / 2;
        sb.append(str.substring(0, splitPos));
        sb.append("...");
        sb.append(str.substring(strLength - splitPos));
        return sb.toString();
    }

    public static String getURLSafe(String url) {
        if (url == null || "".equals(url)) {
            return "";
        }
        StringBuffer strBuff = new StringBuffer();
        char[] charArray = url.toCharArray();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] != '<' && charArray[i] != '>') {
                strBuff.append(charArray[i]);
            }
            ++i;
        }
        return strBuff.toString();
    }

    public static Map String2Map(String properties) {
        return StringHelper.String2Map(properties, PROPERTY_SPLITTER, KEYVALUE_SPLITTER);
    }

    public static Map String2Map(String properties, String outerSplitter, String innerSplitter) {
        Hashtable<String, String> outProperties = new Hashtable<String, String>();
        StringTokenizer tokenizerOuter = new StringTokenizer(properties, outerSplitter);
        while (tokenizerOuter.hasMoreTokens()) {
            String currProperty = tokenizerOuter.nextToken();
            int index = currProperty.indexOf(innerSplitter);
            if (index == -1) continue;
            String value = currProperty.substring(index + 1, currProperty.length());
            outProperties.put(currProperty.substring(0, index), value);
        }
        return outProperties;
    }

    public static String Map2String(Map inProperties) {
        return StringHelper.Map2String(inProperties, PROPERTY_SPLITTER, KEYVALUE_SPLITTER);
    }

    public static String Map2String(Map inProperties, String outerSplitter, String innerSplitter) {
        StringBuffer propertiesBuffer = new StringBuffer();
        for (String key : inProperties.keySet()) {
            Object valueObj = inProperties.get(key);
            propertiesBuffer.append(key).append(innerSplitter).append(valueObj).append(outerSplitter);
        }
        return propertiesBuffer.toString();
    }

    public static List StringArrayToList(String[] strArray) {
        if (strArray == null || strArray.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> list2Return = new ArrayList<String>();
        int i = 0;
        while (i < strArray.length) {
            String str = strArray[i];
            list2Return.add(str);
            ++i;
        }
        return list2Return;
    }

    public static Set StringArrayToSet(String[] strArray) {
        if (strArray == null || strArray.length == 0) {
            return null;
        }
        HashSet<String> set2Return = new HashSet<String>();
        int i = 0;
        while (i < strArray.length) {
            String str = strArray[i];
            set2Return.add(str);
            ++i;
        }
        return set2Return;
    }

    public static int length(String str) {
        if (StringHelper.isEmpty(str)) {
            return 0;
        }
        return str.length();
    }

    public static String convertStreamToString(InputStream is) {
        StringBuffer sb;
        block12: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            sb = new StringBuffer();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String convertStreamToString(InputStream is, String charSet) {
        StringBuffer sb;
        block14: {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is, charSet));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            sb = new StringBuffer();
            String line = null;
            try {
                try {
                    while ((line = reader.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String filterXSS(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        value = value.replaceAll("<", "& lt;").replaceAll(">", "& gt;");
        value = value.replaceAll("\\(", "& #40;").replaceAll("\\)", "& #41;");
        value = value.replaceAll("'", "& #39;");
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", "");
        return value;
    }

    public static final String toString(Object[] number, String token) {
        StringBuffer sb = new StringBuffer();
        if (number != null) {
            int length = number.length;
            int i = 0;
            while (i < number.length) {
                sb.append(number[i]);
                if (i != length - 1) {
                    sb.append(token);
                }
                ++i;
            }
        }
        return sb.toString();
    }

    public static int parseInt(String value) {
        return StringHelper.parseInt(value, -1);
    }

    public static int parseInt(String value, int defValue) {
        if (StringHelper.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static long parseLong(String value) {
        if (StringHelper.isEmpty(value)) {
            return -1L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public static boolean parseBoolean(String value) {
        if (StringHelper.isEmpty(value)) {
            return false;
        }
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String substringByFirstOccurance(String origin, String begin, String end) {
        if (StringHelper.isEmpty(origin)) {
            return null;
        }
        if (!StringHelper.isEmpty(begin) && !StringHelper.isEmpty(end) && begin.equals(end)) {
            return null;
        }
        if (!StringHelper.isEmpty(begin) && origin.indexOf(begin) < 0 || !StringHelper.isEmpty(end) && origin.indexOf(end) < 0) {
            return null;
        }
        int beginIndex = 0;
        if (StringHelper.isEmpty(begin)) {
            beginIndex = 0;
        }
        if (!StringHelper.isEmpty(begin) && origin.indexOf(begin) >= 0) {
            beginIndex = origin.indexOf(begin) + begin.length();
        }
        int endIndex = 0;
        if (StringHelper.isEmpty(end)) {
            endIndex = origin.length();
        }
        if (!StringHelper.isEmpty(end) && origin.indexOf(end, beginIndex) >= 0) {
            endIndex = origin.indexOf(end, beginIndex);
        }
        if (endIndex <= beginIndex) {
            return null;
        }
        String result = origin.substring(beginIndex, endIndex);
        if (StringHelper.isEmpty(result)) {
            return null;
        }
        return result;
    }

    public static int parseIntUsingFormat(String source, String formatPattern) {
        DecimalFormat df = new DecimalFormat(formatPattern);
        try {
            return df.parse(source).intValue();
        }
        catch (ParseException e) {
            return -1;
        }
    }

    public static String parseIntAsStringUsingFormat(int intToFormat, String formatPattern) {
        DecimalFormat df = new DecimalFormat(formatPattern);
        long intOfLong = 0L;
        try {
            intOfLong = new Integer(intToFormat).longValue();
        }
        catch (Exception e) {
            return null;
        }
        try {
            return df.format(intOfLong);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String excludeParamInQueryString(String queryString, String excludeParam) {
        if (StringHelper.isEmpty(queryString)) {
            return null;
        }
        if (StringHelper.isEmpty(excludeParam)) {
            return queryString;
        }
        String[] strArray = StringHelper.split(queryString, PROPERTY_SPLITTER);
        StringBuffer str2Return = new StringBuffer();
        if (strArray == null) {
            return null;
        }
        int i = 0;
        while (i < strArray.length) {
            String str = strArray[i];
            if (!StringHelper.isEmpty(str) && str.indexOf(excludeParam) < 0) {
                if (i > 0) {
                    str2Return.append(PROPERTY_SPLITTER);
                }
                str2Return.append(str);
            }
            ++i;
        }
        String toReturnQueryString = str2Return.toString();
        if (!StringHelper.isEmpty(toReturnQueryString) && toReturnQueryString.indexOf(PROPERTY_SPLITTER) == 0) {
            toReturnQueryString = StringHelper.substringByFirstOccurance(toReturnQueryString, PROPERTY_SPLITTER, null);
        }
        return toReturnQueryString;
    }

    public static String string2Json(String str) {
        StringBuffer sb = new StringBuffer(str.length() + 20);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '/': {
                    sb.append("\\/");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static final String bytesToHex(byte[] buf, int off, int len) {
        char[] out = new char[len * 2];
        int i = 0;
        int j = 0;
        while (i < len) {
            byte a = buf[off++];
            out[j++] = DIGITS[a >>> 4 & 0xF];
            out[j++] = DIGITS[a & 0xF];
            ++i;
        }
        return new String(out);
    }

    public static final String removeFromStringWithSeperator(String stringWithSeperator, String stringToRemove, String seperator) {
        if (StringHelper.isEmpty(stringWithSeperator)) {
            return null;
        }
        if (StringHelper.isEmpty(stringToRemove)) {
            return stringWithSeperator;
        }
        String[] strArray = StringHelper.split(stringWithSeperator, seperator);
        StringBuffer str2Return = new StringBuffer();
        if (strArray == null) {
            return null;
        }
        int i = 0;
        while (i < strArray.length) {
            String str = strArray[i];
            if (!StringHelper.isEmpty(str) && str.indexOf(stringToRemove) < 0) {
                if (i > 0) {
                    str2Return.append(seperator);
                }
                str2Return.append(str);
            }
            ++i;
        }
        String toReturnString = str2Return.toString();
        if (!StringHelper.isEmpty(toReturnString) && toReturnString.indexOf(seperator) == 0) {
            toReturnString = StringHelper.substringByFirstOccurance(toReturnString, seperator, null);
        }
        return toReturnString;
    }

    public static void main(String[] args) {
        System.out.println("aaa".indexOf(null));
    }

    public static String replaceVariableContentWithValue(String contentWithKeyValue, String variableName) {
        if (StringHelper.isEmpty(variableName) || variableName.indexOf("%") == -1) {
            return contentWithKeyValue;
        }
        if (StringHelper.isEmpty(contentWithKeyValue)) {
            return contentWithKeyValue;
        }
        String variableNameFront = variableName.substring(0, variableName.length() - 1);
        if (contentWithKeyValue.indexOf(variableNameFront) == -1) {
            return contentWithKeyValue;
        }
        String variableMatchReg = String.valueOf(variableNameFront) + KEYVALUE_SPLITTER + "([^%]*)" + "%";
        Pattern p = Pattern.compile(variableMatchReg);
        Matcher m = p.matcher(contentWithKeyValue);
        while (m.find()) {
            String matchGroup = m.group();
            matchGroup = matchGroup.replaceAll("\\?", "\\\\?");
            matchGroup = matchGroup.replaceAll("\\$", "\\\\\\$");
            matchGroup = matchGroup.replaceAll("\\{", "\\\\{");
            matchGroup = matchGroup.replaceAll("\\.", "\\\\.");
            matchGroup = matchGroup.replaceAll("\\^", "\\\\\\^");
            matchGroup = matchGroup.replaceAll("\\[", "\\\\[");
            matchGroup = matchGroup.replaceAll("\\(", "\\\\(");
            matchGroup = matchGroup.replaceAll("\\)", "\\\\)");
            matchGroup = matchGroup.replaceAll("\\|", "\\\\|");
            matchGroup = matchGroup.replaceAll("\\*", "\\\\*");
            matchGroup = matchGroup.replaceAll("\\+", "\\\\+");
            String replacedValue = matchGroup.substring(variableNameFront.length() + 1, matchGroup.length() - 1);
            contentWithKeyValue = contentWithKeyValue.replaceFirst(matchGroup, replacedValue);
        }
        return contentWithKeyValue.replaceAll(variableName, "");
    }

    public static String generateRandomCode(int length) {
        StringBuffer code = new StringBuffer();
        code.delete(0, code.capacity() - 1);
        Random random = new Random(new Date().getTime());
        int i = 0;
        while (i < length) {
            code.append(random.nextInt(length + 1));
            ++i;
        }
        return code.toString();
    }

    public static String avoidEmpty(String str, String defaultValue) {
        return StringHelper.isEmpty(str) ? defaultValue : str;
    }

    public static boolean isNotEmpty(String str) {
        return !StringHelper.isEmpty(str);
    }
}

