/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.smtp;

import com.trs.net.smtp.Command;
import com.trs.net.smtp.EhloCommand;
import com.trs.net.smtp.SmtpClientPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class Csmtp {
    static BufferedReader s_oCmdReader;
    static SmtpClientPI s_oClient;
    static HashMap s_oValidCmds;
    static File s_oLocaleDir;
    static boolean s_zOutReplys;
    static boolean s_zPromptFlg;

    public static void main(String[] args) {
        Csmtp.init();
        Csmtp.prepare(args);
        Csmtp.execute();
    }

    private static void init() {
        s_zOutReplys = true;
        s_zPromptFlg = true;
        s_oLocaleDir = new File(System.getProperty("user.dir"));
        s_oClient = new SmtpClientPI();
        s_oCmdReader = new BufferedReader(new InputStreamReader(System.in));
        s_oValidCmds = new HashMap();
        Csmtp.registerCommand(new EhloCommand());
    }

    private static void registerCommand(Command cmd) {
        if (cmd != null && s_oValidCmds != null) {
            String[] s = cmd.getAlias();
            int i = 0;
            while (i < s.length) {
                s_oValidCmds.put(s[i], cmd);
                ++i;
            }
        }
    }

    private static void prepare(String[] args) {
        try {
            Command cmd;
            if (args != null && args.length >= 1 && (cmd = (Command)s_oValidCmds.get("ehlo")) != null) {
                cmd.execute(args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static String readPrompt(String sPrompt) {
        String sLine = null;
        try {
            System.out.print(sPrompt);
            sLine = s_oCmdReader.readLine();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (sLine == null) {
            System.err.println("Unexpected console read failed.");
            System.exit(2);
        }
        return sLine;
    }

    private static String readCommand() {
        return Csmtp.readPrompt("smtp>");
    }

    private static void execute() {
        while (true) {
            String sLine;
            if ((sLine = Csmtp.readCommand()).length() <= 0) {
                continue;
            }
            if (sLine.startsWith("!")) {
                sLine = "! " + sLine.substring(1);
            }
            Csmtp.execCommand(sLine);
        }
    }

    private static void execCommand(String cmd) {
        Command oCommand;
        StringTokenizer st = new StringTokenizer(cmd);
        int iTokenCount = st.countTokens();
        String[] args = null;
        String sKey = st.nextToken().toLowerCase();
        if (iTokenCount > 1) {
            args = new String[iTokenCount - 1];
            int i = 0;
            while (st.hasMoreTokens()) {
                args[i] = st.nextToken();
                ++i;
            }
        }
        if ((oCommand = (Command)s_oValidCmds.get(sKey)) != null) {
            oCommand.exec(args);
        } else {
            System.out.println("Invalid command.");
        }
    }
}

