/*
 * Decompiled with CFR 0.152.
 */
package com.trs.wcm.photo.impl;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.service.IChannelService;
import com.trs.service.IDocumentService;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.photo.IImageLibService;
import com.trs.wcm.photo.ImageInfo;
import java.util.List;

public class ImageLibServiceImpl
implements IImageLibService {
    private IImageLibConfig m_oImageLibConfig = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
    private IChannelService m_oChannelService = (IChannelService)DreamFactory.createObjectById("IChannelService");
    private IDocumentService m_oDocumentService = (IDocumentService)DreamFactory.createObjectById("IDocumentService");
    private IImageLibMgr m_oImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");

    @Override
    public void deleteImage(String _sDocIds) throws WCMException {
        this.m_oDocumentService.delete(_sDocIds, null, false);
        int[] pDocumentIds = CMyString.splitToInt(_sDocIds, ",");
        for (int i = 0; i < pDocumentIds.length; ++i) {
            int nDocumentId = pDocumentIds[i];
            this.m_oImageLibMgr.deleteDocumentQuoteImage(nDocumentId);
        }
    }

    @Override
    public void deleteImage(String _sDocIds, int _nChannelId) throws WCMException {
        this.m_oDocumentService.delete(_sDocIds, Channel.findById(_nChannelId), false);
    }

    @Override
    public List getChannels(User _user, int _nRightIndex) throws WCMException {
        ContextHelper.initContext(_user);
        return this.m_oChannelService.getChildren(this.m_oImageLibConfig.getRelateSite(), _nRightIndex);
    }

    @Override
    public List getChannels(User _user, int _nRightIndex, Channel _channel) throws WCMException {
        ContextHelper.initContext(_user);
        return this.m_oChannelService.getChildren(_channel, _nRightIndex);
    }

    @Override
    public List getChannels(User _user, int _nRightIndex, Channel _channel, WCMFilter _filter) throws WCMException {
        throw new WCMException(I18NMessage.get(ImageLibServiceImpl.class, "ImageLibServiceImpl.label1", "\u6ca1\u6709\u5b9e\u73b0\uff0c\u4f9d\u8d56\u4e8eWCM52\uff01"));
    }

    @Override
    public Documents getDocuments(BaseChannel _oChannel, WCMFilter _filter) throws WCMException {
        return this.m_oChannelService.getDocuments(_oChannel, _filter);
    }

    @Override
    public Document saveImageDetail(Document _document) throws WCMException {
        return this.m_oDocumentService.save(_document, null, null);
    }

    @Override
    public ImageInfo saveImageInfo(ImageInfo _imageInfo) throws WCMException {
        return this.m_oImageLibMgr.saveImageInfo(_imageInfo);
    }

    @Override
    public void quoteImages(int _nDocId, String _sQuoteImageIds) throws WCMException {
        this.m_oImageLibMgr.deleteDocumentQuoteImage(_nDocId, _sQuoteImageIds);
        if (_sQuoteImageIds == null || _sQuoteImageIds.length() == 0 || _sQuoteImageIds == "null") {
            return;
        }
        int[] pQuoteImageIds = CMyString.splitToInt(_sQuoteImageIds, ",");
        for (int i = 0; i < pQuoteImageIds.length; ++i) {
            int nImageId = pQuoteImageIds[i];
            this.m_oImageLibMgr.recordDocumentQuoteImage(_nDocId, nImageId);
        }
    }

    @Override
    public Documents getDocumentsQuoteImage(int _nImageId) throws WCMException {
        return this.m_oImageLibMgr.getDocumentsQuoteImage(_nImageId);
    }

    @Override
    public Appendixes getImageAppendixes(WCMFilter _extraFilter, BaseChannel _oChannelOrSite, boolean _bIncludeImported) throws WCMException {
        return this.m_oImageLibMgr.getImageAppendixes(_extraFilter, _oChannelOrSite, _bIncludeImported);
    }

    @Override
    public ImageInfo[] importImageAppendix(String _sAppendixIds, ImageInfo _imageInfo) throws WCMException {
        int[] pAppendixId = CMyString.splitToInt(_sAppendixIds, ",");
        ImageInfo[] pResult = new ImageInfo[pAppendixId.length];
        for (int i = pAppendixId.length - 1; i >= 0; --i) {
            try {
                pResult[i] = this.importImageAppendix(pAppendixId[i], (ImageInfo)_imageInfo.clone());
                continue;
            }
            catch (CloneNotSupportedException e) {
                throw new WCMException(I18NMessage.get(ImageLibServiceImpl.class, "ImageLibServiceImpl.label2", "\u590d\u5236ImageInfo\u5bf9\u8c61\u5931\u8d25\uff01"), e);
            }
        }
        return pResult;
    }

    @Override
    public ImageInfo importImageAppendix(int _nAppendixId, ImageInfo _imageInfo) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        return this.m_oImageLibMgr.importImageAppendix(loginUser, _nAppendixId, _imageInfo);
    }

    @Override
    public void clearQuotedImages(int _nDocId) throws WCMException {
        this.m_oImageLibMgr.deleteDocumentQuoteImage(_nDocId);
    }
}

