/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.scm.domain.ISCMFavoriteMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.domain.impl.SCMLocalFavoriteMgr;
import com.trs.scm.persistent.Account;
import com.trs.scm.persistent.LocalFavorite;
import com.trs.scm.persistent.LocalFavorites;
import com.trs.scm.sdk.model.Favorite;
import com.trs.scm.sdk.model.FavoriteWrapper;
import com.trs.scm.sdk.model.LocalFavoriteWrapper;
import com.trs.scm.sdk.model.MicroContent;
import com.trs.scm.sdk.model.MicroUser;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SCMFavoriteServiceProvider
implements ISelfDefinedServiceProvider {
    private ISCMFavoriteMgr m_oSCMFavoriteMgr = (ISCMFavoriteMgr)DreamFactory.createObjectById("ISCMFavoriteMgr");
    private static final int DEFAULT_LOCALFAVORITE_WB_ID = -1;
    public static final int DEFAULT_RETWEETED_LOCALFAVORITE_WB_ID = -2;

    public Favorite createFavorite(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccount = Account.findById(nAccountId);
        if (oAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        String sMicroContentId = _oContext.getValue("MicroContentId");
        Favorite oFavorite = null;
        oFavorite = this.m_oSCMFavoriteMgr.createFavorite(oAccount, sMicroContentId);
        if (null != oFavorite && null != oFavorite.getMicroContent() && null != oFavorite.getMicroContent().getId()) {
            this.createLocalFavorite(oAccount.getId(), sMicroContentId, oFavorite, oCurrUser);
        }
        return oFavorite;
    }

    public boolean destroyFavorite(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccount = Account.findById(nAccountId);
        if (oAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        String sMicroContentId = _oContext.getValue("MicroContentId");
        boolean bDestroyFavoriteOk = false;
        bDestroyFavoriteOk = this.m_oSCMFavoriteMgr.destroyFavorite(oAccount, sMicroContentId);
        if (bDestroyFavoriteOk) {
            this.destoryLocalFavorite(nAccountId, sMicroContentId, oCurrUser);
        }
        return bDestroyFavoriteOk;
    }

    public FavoriteWrapper getFavorites(MethodContext _oContext) throws Throwable {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccountToGetFavorites = Account.findById(nAccountId);
        if (oAccountToGetFavorites == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccountToGetFavorites, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        return this.m_oSCMFavoriteMgr.getFavorites(oAccountToGetFavorites, nPageIndex, nPageSize, _oContext.getParams());
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getStringFromStringList(List _oList) {
        if (_oList == null) {
            return "";
        }
        String sResult = "";
        StringBuffer sb = new StringBuffer();
        int len = _oList.size();
        for (int i = 0; i < len; ++i) {
            sb.append(_oList.get(i)).append(",");
        }
        if (sb.length() > 0) {
            sResult = sb.substring(0, sb.length() - 1);
        }
        return sResult;
    }

    private void createLocalFavorite(int _nAccountId, String _sMicroContentId, Favorite _oFavorite, User _oCurrUser) throws WCMException {
        WCMFilter oFilter = new WCMFilter("XWCMLOCALFAVORITE", "ACCOUNTID=? and MICROCONTENTID=?", "", "");
        oFilter.addSearchValues(_nAccountId);
        oFilter.addSearchValues(_sMicroContentId);
        LocalFavorites oLocalFavorites = LocalFavorites.openWCMObjs(_oCurrUser, oFilter);
        if (null != oLocalFavorites && 0 == oLocalFavorites.size()) {
            Date oDate = _oFavorite.getFavoriteTime();
            MicroContent oMicroContent = _oFavorite.getMicroContent();
            LocalFavorite oLocalFavorite = null;
            if (null != oMicroContent) {
                int nRetweetedWBId = -1;
                if (null != oMicroContent.getRetweetedMicroContent()) {
                    MicroContent oRetweetedMicroContent = oMicroContent.getRetweetedMicroContent();
                    LocalFavorite oRetweetedLocalFavorite = new LocalFavorite();
                    oRetweetedLocalFavorite.setMicroContentId(oRetweetedMicroContent.getId());
                    oRetweetedLocalFavorite.setContent(oRetweetedMicroContent.getContent());
                    oRetweetedLocalFavorite.setThumbnailPics(this.getStringFromStringList(oRetweetedMicroContent.getThumbnailPics()));
                    oRetweetedLocalFavorite.setBMiddlePics(this.getStringFromStringList(oRetweetedMicroContent.getBmiddlePics()));
                    oRetweetedLocalFavorite.setOriginalPics(this.getStringFromStringList(oRetweetedMicroContent.getOriginalPics()));
                    oRetweetedLocalFavorite.setIsRetweeted(oRetweetedMicroContent.isRetweeted());
                    oRetweetedLocalFavorite.setRetweetedOriginalId(-2);
                    oRetweetedLocalFavorite.setSource(oRetweetedMicroContent.getSource());
                    oRetweetedLocalFavorite.setAccountId(_nAccountId);
                    if (null != oDate) {
                        oRetweetedLocalFavorite.setFavoriteTime(new CMyDateTime(oDate.getTime()));
                    }
                    if (null != oRetweetedMicroContent.getCreateDate()) {
                        oRetweetedLocalFavorite.setCreateTime(new CMyDateTime(oRetweetedMicroContent.getCreateDate().getTime()));
                    }
                    if (null != oRetweetedMicroContent.getUser()) {
                        MicroUser oUser = oRetweetedMicroContent.getUser();
                        oRetweetedLocalFavorite.setCrUserId(oUser.getId());
                        oRetweetedLocalFavorite.setCrUserName(oUser.getName());
                        oRetweetedLocalFavorite.setCrUserPic(oUser.getHead());
                        oRetweetedLocalFavorite.setDescription(oUser.getDescription());
                        oRetweetedLocalFavorite.setProvinceCode(oUser.getProvinceCode());
                        oRetweetedLocalFavorite.setCityCode(oUser.getCityCode());
                        oRetweetedLocalFavorite.setLocation(oUser.getLocation());
                        oRetweetedLocalFavorite.setIsFollowMe(oUser.isFollowMe());
                        oRetweetedLocalFavorite.setIsFollowing(oUser.isFollowing());
                        oRetweetedLocalFavorite.setIsVIP(oUser.getIsVip());
                        oRetweetedLocalFavorite.setIsMale(oUser.isMale());
                    }
                    oRetweetedLocalFavorite.insert(_oCurrUser);
                    nRetweetedWBId = oRetweetedLocalFavorite.getId();
                }
                oLocalFavorite = new LocalFavorite();
                oLocalFavorite.setMicroContentId(oMicroContent.getId());
                oLocalFavorite.setContent(oMicroContent.getContent());
                oLocalFavorite.setThumbnailPics(this.getStringFromStringList(oMicroContent.getThumbnailPics()));
                oLocalFavorite.setBMiddlePics(this.getStringFromStringList(oMicroContent.getBmiddlePics()));
                oLocalFavorite.setOriginalPics(this.getStringFromStringList(oMicroContent.getOriginalPics()));
                oLocalFavorite.setIsRetweeted(oMicroContent.isRetweeted());
                oLocalFavorite.setRetweetedOriginalId(nRetweetedWBId);
                oLocalFavorite.setSource(oMicroContent.getSource());
                oLocalFavorite.setAccountId(_nAccountId);
                if (null != oDate) {
                    oLocalFavorite.setFavoriteTime(new CMyDateTime(oDate.getTime()));
                }
                if (null != oMicroContent.getCreateDate()) {
                    oLocalFavorite.setCreateTime(new CMyDateTime(oMicroContent.getCreateDate().getTime()));
                }
                if (null != oMicroContent.getUser()) {
                    MicroUser oMicroUser = oMicroContent.getUser();
                    oLocalFavorite.setCrUserId(oMicroUser.getId());
                    oLocalFavorite.setCrUserName(oMicroUser.getName());
                    oLocalFavorite.setCrUserPic(oMicroUser.getHead());
                    oLocalFavorite.setDescription(oMicroUser.getHead());
                    oLocalFavorite.setProvinceCode(oMicroUser.getProvinceCode());
                    oLocalFavorite.setCityCode(oMicroUser.getCityCode());
                    oLocalFavorite.setLocation(oMicroUser.getLocation());
                    oLocalFavorite.setIsFollowMe(oMicroUser.isFollowMe());
                    oLocalFavorite.setIsFollowing(oMicroUser.isFollowing());
                    oLocalFavorite.setIsVIP(oMicroUser.getIsVip());
                    oLocalFavorite.setIsMale(oMicroUser.isMale());
                }
                oLocalFavorite.save(this.getLoginUser());
            }
        }
    }

    private void destoryLocalFavorite(int _nAccountId, String _sMicroContentId, User _oCurrUser) throws WCMException {
        WCMFilter oFilter = new WCMFilter("XWCMLOCALFAVORITE", "ACCOUNTID=? and MICROCONTENTID=?", "", "");
        oFilter.addSearchValues(_nAccountId);
        oFilter.addSearchValues(_sMicroContentId);
        LocalFavorites oLocalFavorites = LocalFavorites.openWCMObjs(_oCurrUser, oFilter);
        if (null != oLocalFavorites && oLocalFavorites.size() > 0) {
            LocalFavorite oMyLocalFavorite;
            long nRetweetedOriginalId = (Long)oLocalFavorites.getAt(0).getProperty("RETWEETEDORIGINALID");
            oLocalFavorites.removeAll(true);
            if (-2L != nRetweetedOriginalId && -1L != nRetweetedOriginalId && null != (oMyLocalFavorite = LocalFavorite.findById((int)nRetweetedOriginalId))) {
                oMyLocalFavorite.delete(_oCurrUser);
            }
        }
    }

    public void deleteLocalFavorite(MethodContext _oContext) throws Exception {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccount = Account.findById(nAccountId);
        if (oAccount == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccount, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        String sMicroContentId = _oContext.getValue("MicroContentId");
        this.destoryLocalFavorite(nAccountId, sMicroContentId, oCurrUser);
    }

    public LocalFavoriteWrapper queryLocalFavorites(MethodContext _oContext) throws Exception {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccountToGetFavorites = Account.findById(nAccountId);
        if (oAccountToGetFavorites == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccountToGetFavorites, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        int nPageIndex = _oContext.getValue("PageIndex", 1);
        int nPageSize = _oContext.getValue("PageSize", 10);
        String sSearchContent = _oContext.getValue("SearchContent");
        HashMap<String, String> extraParams = new HashMap<String, String>();
        extraParams.put("sSearchContent", sSearchContent);
        SCMLocalFavoriteMgr oLocalFavoriteMgr = new SCMLocalFavoriteMgr();
        LocalFavoriteWrapper oLocalFavoriteWrapper = oLocalFavoriteMgr.queryLocalFavorites(nAccountId, nPageIndex, nPageSize, extraParams);
        return oLocalFavoriteWrapper;
    }

    public LocalFavorite findLocalFavoriteById(MethodContext _oContext) throws Exception {
        User oCurrUser = this.getLoginUser();
        int nAccountId = _oContext.getValue("AccountId", 0);
        Account oAccountToGetFavorites = Account.findById(nAccountId);
        if (oAccountToGetFavorites == null) {
            throw new WCMException("\u8d26\u53f7\u4e0d\u5b58\u5728\uff01[ID=" + nAccountId + "]");
        }
        if (!SCMAuthServer.hasRight(oCurrUser, oAccountToGetFavorites, 44)) {
            throw new WCMException("\u60a8\u5bf9\u8be5\u8d26\u53f7\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\uff01[ID=" + nAccountId + "]");
        }
        int nLocalFavoriteId = _oContext.getValue("LocalFavoriteId", 0);
        LocalFavorite oLocalFavorite = null;
        try {
            oLocalFavorite = LocalFavorite.findById(nLocalFavoriteId);
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        return oLocalFavorite;
    }
}

