/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.cache.ICacheMgr;
import com.trs.scm.domain.SCMAuthServer;
import com.trs.scm.persistent.SCMGroup;
import com.trs.scm.persistent.SCMGroupUser;
import com.trs.scm.persistent.SCMGroups;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SCMGroupUserCacheMgr
implements ICacheMgr {
    private static Logger logger = Logger.getLogger(SCMGroupUserCacheMgr.class);
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");
    private static int MAX_CACHE_SIZE = 100;

    @Override
    public void clear() {
    }

    @Override
    public boolean init() throws WCMException {
        return this.doStart();
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.doStart();
    }

    private synchronized boolean doStart() throws WCMException {
        if (cache.exists(this.getKey("scmGroup")).booleanValue() && cache.exists(this.getKey("scmUser")).booleanValue()) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"init SCMGroupUsersCache & UserSCMGroupsCache ....");
        }
        if (!cache.exists(this.getKey("scmGroup")).booleanValue()) {
            this.initSCMGroupUsersCache();
        }
        if (!cache.exists(this.getKey("scmUser")).booleanValue()) {
            this.initUsersSCMGroupsCache();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SCMGroupUsersCache & UserSCMGroupsCache are inited....");
        }
        return true;
    }

    private void initUsersSCMGroupsCache() throws WCMException {
        String sWhere = "exists (select 1 from XWCMSCMGROUPUSER  where XWCMSCMGROUPUSER.UserId = WCMUser.UserId)";
        WCMFilter oFilter = new WCMFilter("", sWhere, "");
        Users oUsers = Users.openWCMObjs(null, oFilter);
        int nSize = oUsers.size();
        for (int i = 0; i < MAX_CACHE_SIZE && i < nSize; ++i) {
            User oUser = (User)oUsers.getAt(i);
            if (oUser == null) continue;
            int nUserId = oUser.getId();
            SCMGroups oSCMGroups = this.loadSCMGroupsOfUser(nUserId);
            this.baseObj2Ids(oSCMGroups, this.getUserKey(nUserId));
        }
        cache.set(this.getKey("scmUser"), "true");
    }

    private void initSCMGroupUsersCache() throws WCMException {
        SCMGroups oSCMGroups = SCMGroups.openWCMObjs(null, null);
        int nSize = oSCMGroups.size();
        for (int i = 0; i < MAX_CACHE_SIZE && i < nSize; ++i) {
            SCMGroup oSCMGroup = (SCMGroup)oSCMGroups.getAt(i);
            if (oSCMGroup == null) continue;
            int nSCMGroupId = oSCMGroup.getId();
            Users oUsers = this.loadAdminsOfSCMGroup(nSCMGroupId);
            this.baseObj2Ids(oUsers, this.getGroupKey(nSCMGroupId));
        }
        cache.set(this.getKey("scmGroup"), "true");
    }

    private void baseObj2Ids(BaseObjs objs, String key) {
        if (objs == null) {
            return;
        }
        cache.clear(key);
        int size = objs.size();
        for (int i = 0; i < size; ++i) {
            BaseObj obj = objs.getAt(i);
            Integer id = obj.getId();
            cache.rpush(key, id);
        }
    }

    private void ensureCacheLoaded() throws WCMException {
        if (!cache.exists(this.getKey("scmUser")).booleanValue() || !cache.exists(this.getKey("scmGroup")).booleanValue()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Ensure the SCM Cache is loaded! init the Cahce....");
            }
            this.doStart();
        }
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!this.isListening(_oObjAdded)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Return ----- Not the listening object! ObjectType - [" + _oObjAdded.getWCMType() + "]"));
            }
            return;
        }
        this.ensureCacheLoaded();
        if (_oObjAdded instanceof SCMGroupUser) {
            SCMGroupUser oSCMGroupUser = (SCMGroupUser)_oObjAdded;
            int nSCMGroupId = oSCMGroupUser.getSCMGroupId();
            int nUserId = oSCMGroupUser.getUserId();
            SCMGroups oSCMGroups = this.loadSCMGroupsOfUser(nUserId);
            if (oSCMGroups == null) {
                oSCMGroups = SCMGroups.createNewInstance(null);
            }
            oSCMGroups.addElement(SCMGroup.findById(nSCMGroupId));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("update the adding SCMGroupUser into Cache, UserId [" + nUserId + "] & belonged groups' size: " + oSCMGroups.size() + "....."));
            }
            this.baseObj2Ids(oSCMGroups, this.getUserKey(nUserId));
            String sSCMGroupId = Integer.toString(nSCMGroupId);
            Users oUsers = this.loadAdminsOfSCMGroup(nSCMGroupId);
            if (oUsers == null) {
                oUsers = Users.createNewInstance(null);
            }
            oUsers.addElement(User.findById(nUserId));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("update the modified SCMGroupUser into Cache, SCMGroupId [" + sSCMGroupId + "] & its User's size: " + oUsers.size() + "....."));
            }
            this.baseObj2Ids(oUsers, this.getGroupKey(nSCMGroupId));
        } else {
            SCMGroup oSCMGroup = (SCMGroup)_oObjAdded;
            int nSCMGroupId = oSCMGroup.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("update the added SCMGroup into Cache, SCMGroupId [" + nSCMGroupId + "] & its User's size: " + 0 + "....."));
            }
            Users newUsers = Users.createNewInstance(null);
            this.baseObj2Ids(newUsers, this.getGroupKey(nSCMGroupId));
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int eventType) throws WCMException {
        if (!this.isListening(_oObjDeleted)) {
            return;
        }
        this.ensureCacheLoaded();
        if (_oObjDeleted instanceof SCMGroupUser) {
            long resultUser;
            SCMGroupUser oSCMGroupUser = (SCMGroupUser)_oObjDeleted;
            int nSCMGroupId = oSCMGroupUser.getSCMGroupId();
            int nUserId = oSCMGroupUser.getUserId();
            long resultGroup = cache.lrem(this.getUserKey(nUserId), 0L, nSCMGroupId);
            if (resultGroup > 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing the deleting Group [" + nSCMGroupId + "] from Cache successfully...."));
                    logger.debug((Object)"Put the updated Groups into Cache.....");
                }
            } else {
                logger.error((Object)("Removing Group [" + nSCMGroupId + "] from Cache failed..."));
            }
            if ((resultUser = cache.lrem(this.getGroupKey(nSCMGroupId), 0L, nUserId).longValue()) > 0L) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Removing the deleting user [" + nUserId + "] from Cache successfully...."));
                    logger.debug((Object)"Put the updated Users into Cache.....");
                }
            } else {
                logger.error((Object)("Removing User [" + nUserId + "] from Cache failed..."));
            }
        } else {
            SCMGroup oSCMGroup = (SCMGroup)_oObjDeleted;
            int nSCMGroupId = oSCMGroup.getId();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Removing the deleting SCMGroup [" + nSCMGroupId + "] from Cache...."));
            }
            cache.clear(this.getGroupKey(nSCMGroupId));
            List<Object> userIds = cache.lrange(this.getGroupKey(nSCMGroupId), 0L, -1L);
            Users oSCMGroupAdmins = Users.findByIds(null, StringUtils.join(userIds, (String)","));
            if (oSCMGroupAdmins != null) {
                for (int i = 0; i < oSCMGroupAdmins.size(); ++i) {
                    SCMGroups oSCMGroups;
                    User user = (User)oSCMGroupAdmins.getAt(i);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("updating the deleting SCMGroup [" + nSCMGroupId + "]'s Users in Cache...."));
                    }
                    if ((oSCMGroups = this.querySCMGroupsOfUser(user.getId())) != null) {
                        long result = cache.lrem(this.getUserKey(user.getId()), 0L, nSCMGroupId);
                        if (result > 0L) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Removing the deleting SCMGroup [" + nSCMGroupId + "] from Cache successfully...."));
                            logger.debug((Object)"Put the updated Groups into Cache.....");
                            logger.debug((Object)("the updated User -[" + user.getId() + "] & Groups' size - " + (oSCMGroups.size() - 1)));
                            continue;
                        }
                        logger.error((Object)("Removing Group [" + nSCMGroupId + "] from Cache failed..."));
                        continue;
                    }
                    cache.clear(this.getUserKey(user.getId()));
                }
            }
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _objModified, int eventType) throws WCMException {
        if (!this.isListening(_objModified)) {
            return;
        }
        this.ensureCacheLoaded();
        if (_objModified instanceof SCMGroup) {
            int nSCMGroupId;
            Users oUsers;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"is Listening For SCMGroup Modifying ...");
            }
            if ((oUsers = this.loadAdminsOfSCMGroup(nSCMGroupId = _objModified.getId())) == null) {
                oUsers = (Users)Users.createInstance(Users.class);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("the modified group has " + oUsers.size() + " users..."));
            }
            int nSize = oUsers.size();
            for (int i = 0; i < nSize; ++i) {
                User oTempUser = (User)oUsers.getAt(i);
                if (oTempUser == null) continue;
                int nUserId = oTempUser.getId();
                SCMGroups oTempGroups = this.loadSCMGroupsOfUser(nUserId);
                String sUserId = Integer.toString(nUserId);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("update the user [" + sUserId + "] 's groups, size is " + oTempGroups.size()));
                }
                this.baseObj2Ids(oTempGroups, this.getUserKey(nUserId));
            }
        }
    }

    private boolean isListening(BaseObj _oBaseObj) {
        return _oBaseObj != null && (_oBaseObj instanceof SCMGroupUser || _oBaseObj instanceof SCMGroup);
    }

    public SCMGroups querySCMGroupsOfUser(int _nUserId) throws WCMException {
        List<Object> groupIds;
        SCMGroups groups;
        if (SCMAuthServer.isAdminOfSCM(User.findById(_nUserId))) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("User [" + _nUserId + "] is Admin~ return the data from DB...."));
            }
            return this.loadSCMGroupsOfSCMAdmins();
        }
        if (cache.exists(this.getKey("scmUser")).booleanValue() && (groups = SCMGroups.findByIds(null, StringUtils.join(groupIds = cache.lrange(this.getUserKey(_nUserId), 0L, -1L), (String)","))) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Load Data from Cache, the managed group size for user [" + _nUserId + "] is: " + groups.size()));
            }
            return groups;
        }
        SCMGroups oSCMGroups = this.loadSCMGroupsOfUser(_nUserId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No releated Data in Cache, Load data from DB, the managed group size for user [" + _nUserId + "] is: " + oSCMGroups == null ? 0 : oSCMGroups.size()));
        }
        this.baseObj2Ids(oSCMGroups, this.getUserKey(_nUserId));
        cache.set(this.getKey("scmUser"), "true");
        return oSCMGroups;
    }

    public Users queryAdminsOfSCMGroup(int _nSCMGroupId) throws WCMException {
        List<Object> userIds;
        Users oUsers;
        if (cache.exists(this.getKey("scmGroup")).booleanValue() && (oUsers = Users.findByIds(null, StringUtils.join(userIds = cache.lrange(this.getGroupKey(_nSCMGroupId), 0L, -1L), (String)","))) != null) {
            User oTempUser = null;
            for (int i = 0; i < oUsers.size(); ++i) {
                oTempUser = (User)oUsers.getAt(i);
                int nStatus = oTempUser.getStatus();
                if (nStatus == 30) continue;
                oUsers.remove(oUsers.getAt(i), false);
                cache.lrem(this.getGroupKey(_nSCMGroupId), 0L, oUsers.getAt(i).getId());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Load Data from Cache, the group admin size for group [" + _nSCMGroupId + "] is: " + oUsers.size()));
            }
            return oUsers;
        }
        Users oUsers2 = this.loadAdminsOfSCMGroup(_nSCMGroupId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No releated Data in Cache, Load data from DB, the group admin size for group [" + _nSCMGroupId + "] is: " + oUsers2 == null ? 0 : oUsers2.size()));
        }
        this.baseObj2Ids(oUsers2, this.getGroupKey(_nSCMGroupId));
        cache.set(this.getKey("scmGroup"), "true");
        return oUsers2;
    }

    private SCMGroups loadSCMGroupsOfUser(int _nUserId) throws WCMException {
        String sWhere = "USERID = ?";
        String sFrom = "XWCMSCMGROUPUSER";
        WCMFilter oFilter = new WCMFilter(sFrom, sWhere, "");
        oFilter.addSearchValues(_nUserId);
        SCMGroups oSCMGroups = SCMGroups.openWCMObjs(null, oFilter);
        return oSCMGroups;
    }

    private Users loadAdminsOfSCMGroup(int _nSCMGroupId) throws WCMException {
        String sWhere = "exists (select 1 from XWCMSCMGROUPUSER  where SCMGROUPID = ? and XWCMSCMGROUPUSER.UserId = WCMUser.UserId)";
        WCMFilter oFilter = new WCMFilter("", sWhere, "");
        oFilter.addSearchValues(_nSCMGroupId);
        Users oUsers = Users.openWCMObjs(null, oFilter);
        return oUsers;
    }

    private SCMGroups loadSCMGroupsOfSCMAdmins() throws WCMException {
        String sFrom = "XWCMSCMGROUP";
        WCMFilter oFilter = new WCMFilter(sFrom, "", "");
        SCMGroups oSCMGroups = SCMGroups.openWCMObjs(null, oFilter);
        return oSCMGroups;
    }

    private String getKey() {
        return SCMGroupUserCacheMgr.class.getName();
    }

    private String getGroupKey(Integer groupId) {
        if (groupId == null) {
            return null;
        }
        return this.getKey() + ".group" + groupId;
    }

    private String getUserKey(Integer userId) {
        if (userId == null) {
            return null;
        }
        return this.getKey() + ".user" + userId;
    }

    private String getKey(String key) {
        return this.getKey() + "." + key;
    }
}

