/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scene.parser;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import com.trs.scene.parser.SceneConnector;
import com.trs.scene.parser.SceneNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SceneXMLParser {
    private static Logger logger = Logger.getLogger(SceneXMLParser.class);
    private SceneNode m_oFirstNode = null;
    private String m_sXMLContent = null;

    public SceneXMLParser(String _sXMLContent) {
        this.m_sXMLContent = _sXMLContent;
    }

    public SceneNode parse() throws WCMException {
        Element rootElement = null;
        try {
            rootElement = DocumentHelper.parseText((String)this.m_sXMLContent).getRootElement().element("root");
        }
        catch (DocumentException e) {
            logger.error((Object)I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label1", "\u89e3\u6790XML\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
            logger.info((Object)"==========XML Content===========");
            logger.info((Object)this.m_sXMLContent);
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label1", "\u89e3\u6790XML\u51fa\u73b0\u5f02\u5e38\uff01"), e);
        }
        HashMap hNodes = this.makeNodes(rootElement);
        if (hNodes.size() == 0) {
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label2", "\u6570\u636e\u9519\u8bef\uff0c\u6ca1\u6709\u4e00\u4e2a\u8282\u70b9\uff01"));
        }
        this.makeConnectors(rootElement, hNodes);
        return this.m_oFirstNode;
    }

    private void makeConnectors(Element rootElement, HashMap _hNodes) throws WCMException {
        ArrayList<Integer> arNotFirstNodeIds = new ArrayList<Integer>();
        List arElementConnectors = rootElement.elements("Connector");
        int nConnectorCount = arElementConnectors.size();
        if (nConnectorCount == 0) {
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label3", "\u6570\u636e\u6709\u8bef\uff0c\u8fde\u63a5\u5bf9\u8c61\u5728XML\u4e2d\u90fd\u4e0d\u5b58\u5728\uff1f"));
        }
        for (int i = 0; i < nConnectorCount; ++i) {
            Element elCell;
            Element elConnector = (Element)arElementConnectors.get(i);
            SceneConnector connector = this.makeConnector(elConnector);
            if (connector == null || (elCell = elConnector.element("FDCell")) == null) continue;
            String sPreNodeId = elCell.attributeValue("source");
            if (CMyString.isEmpty(sPreNodeId)) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label4", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u8d77\u59cb\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + connector.getName() + ", ID=" + connector.getId() + "]");
            }
            int nPreNodeId = 0;
            try {
                nPreNodeId = Integer.parseInt(sPreNodeId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (nPreNodeId <= 0) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label4", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u8d77\u59cb\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + connector.getName() + ", ID=" + connector.getId() + "]");
            }
            SceneNode oPreNode = (SceneNode)_hNodes.get(new Integer(nPreNodeId));
            if (oPreNode == null) continue;
            connector.setPreNode(oPreNode);
            String sNextNodeId = elCell.attributeValue("target");
            if (CMyString.isEmpty(sNextNodeId)) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label5", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u76ee\u6807\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + connector.getName() + ", ID=" + connector.getId() + "]");
            }
            int nNextNodeId = 0;
            try {
                nNextNodeId = Integer.parseInt(sNextNodeId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (nNextNodeId <= 0) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label5", "\u8fde\u7ebf\u6709\u8bef\uff0c\u6ca1\u6709\u76ee\u6807\u8282\u70b9![\u8fde\u7ebf\u540d\u79f0=") + connector.getName() + ", ID=" + connector.getId() + "]");
            }
            if (nPreNodeId == nNextNodeId) {
                throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label6", "\u8fde\u7ebf\u6709\u8bef\uff0c\u8d77\u59cb\u548c\u7ed3\u675f\u4e00\u6837![\u8fde\u7ebf\u540d\u79f0=") + connector.getName() + ", ID=" + connector.getId() + "]");
            }
            Integer iNextNodeKey = new Integer(nNextNodeId);
            SceneNode oNextNode = (SceneNode)_hNodes.get(iNextNodeKey);
            if (oNextNode == null) continue;
            connector.setNextNode(oNextNode);
            arNotFirstNodeIds.add(iNextNodeKey);
            oPreNode.addNextConnector(connector);
        }
        int nFirstNodeCount = 0;
        for (Object iKey : _hNodes.keySet()) {
            if (arNotFirstNodeIds.contains(iKey)) continue;
            ++nFirstNodeCount;
            this.m_oFirstNode = (SceneNode)_hNodes.get(iKey);
        }
        if (nFirstNodeCount == 0) {
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label7", "\u6ca1\u6709\u7b2c\u4e00\u4e2a\u8282\u70b9\u6709\u591a\u4e2a\uff1f[arNotFirstNodeIds=") + arNotFirstNodeIds + "]");
        }
        if (nFirstNodeCount > 1) {
            StringBuffer sbErrorInfo = new StringBuffer();
            Iterator itKeys = _hNodes.keySet().iterator();
            int nIndex = 0;
            while (itKeys.hasNext()) {
                Object iKey = itKeys.next();
                if (arNotFirstNodeIds.contains(iKey)) continue;
                SceneNode oFirstNode = (SceneNode)_hNodes.get(iKey);
                sbErrorInfo.append(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label8", "\u8282\u70b9") + ++nIndex + I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label9", "\u540d\u79f0=[") + oFirstNode.getName() + "] Id=[" + oFirstNode.getId() + "]");
            }
            throw new WCMException(I18NMessage.get(SceneXMLParser.class, "SceneXMLParser.label10", "\u7b2c\u4e00\u4e2a\u8282\u70b9\u6709\u591a\u4e2a\uff1f[Count=") + nFirstNodeCount + "]" + sbErrorInfo);
        }
    }

    private HashMap makeNodes(Element _rootElement) {
        List arElementNodes = _rootElement.elements("Rect");
        int nSize = arElementNodes.size();
        HashMap<Integer, SceneNode> hNodes = new HashMap<Integer, SceneNode>(nSize + 10);
        for (int i = 0; i < nSize; ++i) {
            Element elNode = (Element)arElementNodes.get(i);
            SceneNode node = this.makeNode(elNode);
            if (node == null) continue;
            hNodes.put(node.getKey(), node);
        }
        List arElementShapes = _rootElement.elements("Shape");
        nSize = arElementShapes.size();
        for (int i = 0; i < nSize; ++i) {
            Element elNode = (Element)arElementShapes.get(i);
            SceneNode node = this.makeNode(elNode);
            if (node == null) continue;
            hNodes.put(node.getKey(), node);
        }
        return hNodes;
    }

    private SceneNode makeNode(Element _elNode) {
        String sId = _elNode.attributeValue("id");
        if (CMyString.isEmpty(sId)) {
            return null;
        }
        int nId = 0;
        try {
            nId = Integer.parseInt(sId);
        }
        catch (NumberFormatException e) {
            return null;
        }
        String sName = _elNode.attributeValue("label");
        SceneNode node = new SceneNode(nId, sName);
        return node;
    }

    private SceneConnector makeConnector(Element _elNode) {
        String sId = _elNode.attributeValue("id");
        if (CMyString.isEmpty(sId)) {
            return null;
        }
        int nId = 0;
        try {
            nId = Integer.parseInt(sId);
        }
        catch (NumberFormatException e) {
            return null;
        }
        String sName = _elNode.attributeValue("label");
        SceneConnector connector = new SceneConnector(nId, sName);
        return connector;
    }
}

