/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.CRC32;
import com.trs.infra.util.jazzlib.Deflater;
import com.trs.infra.util.jazzlib.DeflaterOutputStream;
import com.trs.infra.util.jazzlib.GZIPConstants;
import java.io.IOException;
import java.io.OutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream
implements GZIPConstants {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream out) throws IOException {
        this(out, 4096);
    }

    public GZIPOutputStream(OutputStream out, int size) throws IOException {
        super(out, new Deflater(-1, true), size);
        int mod_time = (int)(System.currentTimeMillis() / 1000L);
        byte[] gzipHeader = new byte[]{31, -117, 8, 0, (byte)mod_time, (byte)(mod_time >> 8), (byte)(mod_time >> 16), (byte)(mod_time >> 24), 0, -1};
        out.write(gzipHeader);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.crc.update(buf, off, len);
        super.write(buf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    @Override
    public void finish() throws IOException {
        super.finish();
        int totalin = this.def.getTotalIn();
        int crcval = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
        byte[] gzipFooter = new byte[]{(byte)crcval, (byte)(crcval >> 8), (byte)(crcval >> 16), (byte)(crcval >> 24), (byte)totalin, (byte)(totalin >> 8), (byte)(totalin >> 16), (byte)(totalin >> 24)};
        this.out.write(gzipFooter);
    }
}

