/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.jazzlib;

import com.trs.infra.util.jazzlib.CRC32;
import com.trs.infra.util.jazzlib.GZIPConstants;
import com.trs.infra.util.jazzlib.Inflater;
import com.trs.infra.util.jazzlib.InflaterInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class GZIPInputStream
extends InflaterInputStream
implements GZIPConstants {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean readGZIPHeader;

    public GZIPInputStream(InputStream in) throws IOException {
        this(in, 4096);
    }

    public GZIPInputStream(InputStream in, int size) throws IOException {
        super(in, new Inflater(true), size);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        if (!this.readGZIPHeader) {
            this.readHeader();
        }
        if (this.eos) {
            return -1;
        }
        int numRead = super.read(buf, offset, len);
        if (numRead > 0) {
            this.crc.update(buf, offset, numRead);
        }
        if (this.inf.finished()) {
            this.readFooter();
        }
        return numRead;
    }

    private void readHeader() throws IOException {
        int readByte;
        int readByte2;
        int i;
        CRC32 headCRC = new CRC32();
        int magic = this.in.read();
        if (magic < 0) {
            this.eos = true;
            return;
        }
        headCRC.update(magic);
        if (magic != 31) {
            throw new IOException("Error in GZIP header, first byte doesn't match");
        }
        magic = this.in.read();
        if (magic != 139) {
            throw new IOException("Error in GZIP header,  second byte doesn't match");
        }
        headCRC.update(magic);
        int CM = this.in.read();
        if (CM != 8) {
            throw new IOException("Error in GZIP header, data not in deflate format");
        }
        headCRC.update(CM);
        int flags = this.in.read();
        if (flags < 0) {
            throw new EOFException("Early EOF in GZIP header");
        }
        headCRC.update(flags);
        if ((flags & 0xD0) != 0) {
            throw new IOException("Reserved flag bits in GZIP header != 0");
        }
        for (i = 0; i < 6; ++i) {
            readByte2 = this.in.read();
            if (readByte2 < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            headCRC.update(readByte2);
        }
        if ((flags & 4) != 0) {
            for (i = 0; i < 2; ++i) {
                readByte2 = this.in.read();
                if (readByte2 < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                headCRC.update(readByte2);
            }
            if (this.in.read() < 0 || this.in.read() < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            int len1 = this.in.read();
            int len2 = this.in.read();
            if (len1 < 0 || len2 < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            headCRC.update(len1);
            headCRC.update(len2);
            int extraLen = len1 << 8 | len2;
            for (int i2 = 0; i2 < extraLen; ++i2) {
                int readByte3 = this.in.read();
                if (readByte3 < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                headCRC.update(readByte3);
            }
        }
        if ((flags & 8) != 0) {
            while ((readByte = this.in.read()) > 0) {
                headCRC.update(readByte);
            }
            if (readByte < 0) {
                throw new EOFException("Early EOF in GZIP file name");
            }
            headCRC.update(readByte);
        }
        if ((flags & 0x10) != 0) {
            while ((readByte = this.in.read()) > 0) {
                headCRC.update(readByte);
            }
            if (readByte < 0) {
                throw new EOFException("Early EOF in GZIP comment");
            }
            headCRC.update(readByte);
        }
        if ((flags & 2) != 0) {
            int crcval = this.in.read();
            if (crcval < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            int tempByte = this.in.read();
            if (tempByte < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            if ((crcval = crcval << 8 | tempByte) != ((int)headCRC.getValue() & 0xFFFF)) {
                throw new IOException("Header CRC value mismatch");
            }
        }
        this.readGZIPHeader = true;
    }

    private void readFooter() throws IOException {
        int count;
        byte[] footer = new byte[8];
        int avail = this.inf.getRemaining();
        if (avail > 8) {
            avail = 8;
        }
        System.arraycopy(this.buf, this.len - this.inf.getRemaining(), footer, 0, avail);
        for (int needed = 8 - avail; needed > 0; needed -= count) {
            count = this.in.read(footer, 8 - needed, needed);
            if (count > 0) continue;
            throw new EOFException("Early EOF in GZIP footer");
        }
        int crcval = footer[0] & 0xFF | (footer[1] & 0xFF) << 8 | (footer[2] & 0xFF) << 16 | footer[3] << 24;
        if (crcval != (int)this.crc.getValue()) {
            throw new IOException("GZIP crc sum mismatch, theirs \"" + Integer.toHexString(crcval) + "\" and ours \"" + Integer.toHexString((int)this.crc.getValue()));
        }
        int total = footer[4] & 0xFF | (footer[5] & 0xFF) << 8 | (footer[6] & 0xFF) << 16 | footer[7] << 24;
        if (total != this.inf.getTotalOut()) {
            throw new IOException("Number of bytes mismatch");
        }
        this.eos = true;
    }
}

