/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.html;

import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.html.HtmlComment;
import com.trs.infra.util.html.HtmlElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class HtmlDocument {
    private static final int INITIAL_ARRAY_SIZE = 5;
    protected List content = new ArrayList(5);

    public HtmlDocument() {
    }

    public HtmlDocument(HtmlElement _rootElement) {
        this.setRootElement(_rootElement);
    }

    public List getContent() {
        return this.content;
    }

    public HtmlDocument setContent(List _newContent) throws CMyException {
        if (_newContent == null) {
            return this;
        }
        boolean bDidRoot = false;
        Iterator itr = _newContent.iterator();
        this.content = new ArrayList(5);
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (obj instanceof HtmlElement) {
                if (!bDidRoot) {
                    this.setRootElement((HtmlElement)obj);
                    bDidRoot = true;
                    continue;
                }
                throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label1", "\u6587\u5f53\u4e2d\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u6839\u5143\u7d20(HtmlDocument.setContent)"));
            }
            if (obj instanceof HtmlComment) {
                this.addContent((HtmlComment)obj);
                continue;
            }
            throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label2", "\u65e0\u6548\u7684\u6587\u6863\u5185\u5bb9(HtmlDocument.setContent)"));
        }
        if (!bDidRoot) {
            throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label3", "\u6587\u6863\u7f3a\u5c11\u6839\u5143\u7d20\uff08HtmlDocument.setContent\uff09"));
        }
        return this;
    }

    public HtmlElement getRootElement() {
        for (Object obj : this.content) {
            if (!(obj instanceof HtmlElement)) continue;
            return (HtmlElement)obj;
        }
        return null;
    }

    public HtmlDocument setRootElement(HtmlElement _rootElement) {
        if (_rootElement == null) {
            return this;
        }
        boolean bHadRoot = false;
        ListIterator<HtmlElement> itr = this.content.listIterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof HtmlElement)) continue;
            HtmlElement departingRoot = (HtmlElement)obj;
            departingRoot.setDocument(null);
            itr.set(_rootElement);
            bHadRoot = true;
            break;
        }
        if (!bHadRoot) {
            itr.add(_rootElement);
        }
        _rootElement.setDocument(null);
        return this;
    }

    public HtmlDocument addContent(HtmlComment _comment) throws CMyException {
        if (_comment == null) {
            return this;
        }
        if (_comment.getParent() != null || _comment.getDocument() != null) {
            throw new CMyException(1, I18NMessage.get(HtmlDocument.class, "HtmlDocument.label4", "\u6dfb\u52a0\u7684\u5185\u5bb9\u5df2\u7ecf\u5b58\u5728Parent\uff08HtmlDocument.addContent\uff09"));
        }
        this.content.add(_comment);
        return this;
    }

    public List getElementsByName(String _name) {
        HtmlElement root = this.getRootElement();
        if (root == null) {
            return new ArrayList(1);
        }
        return root.getElementsByName(_name);
    }

    public String toString() {
        if (this.content == null || this.content.size() < 1) {
            return "";
        }
        StringBuffer textContent = new StringBuffer();
        for (Object obj : this.content) {
            if (obj instanceof HtmlComment) {
                textContent.append(((HtmlComment)obj).toString());
            } else if (obj instanceof HtmlElement) {
                textContent.append(((HtmlElement)obj).toString());
            }
            textContent.append("\n");
        }
        return textContent.toString();
    }

    public boolean fromString(String _strSrc) throws CMyException {
        if (this.content != null) {
            this.content.clear();
        }
        if ((_strSrc = _strSrc.trim()).length() < 1) {
            return false;
        }
        HtmlElement docElement = new HtmlElement();
        if (docElement.fromString("<_DOM>" + _strSrc + "</_DOM>") < 1) {
            return false;
        }
        List lstContent = docElement.getContent();
        if (lstContent == null) {
            return false;
        }
        for (Object obj : lstContent) {
            if (obj == null) continue;
            if (obj instanceof HtmlComment) {
                ((HtmlComment)obj).setParent(null);
                this.addContent((HtmlComment)obj);
                continue;
            }
            if (!(obj instanceof HtmlElement)) continue;
            ((HtmlElement)obj).setParent(null);
            this.setRootElement((HtmlElement)obj);
        }
        return true;
    }

    public boolean loadFromFile(String _sFilePathName) throws CMyException {
        String strDoc = CMyFile.readFile(_sFilePathName);
        return this.fromString(strDoc);
    }

    public void saveToFile(String _sFilePathName) throws CMyException {
        String strDoc = this.toString();
        CMyFile.writeFile(_sFilePathName, strDoc);
    }

    public static void main(String[] args) {
        HtmlDocument htmlDoc = new HtmlDocument();
        HtmlElement element = null;
        List elements = null;
        try {
            String sFile = "d:\\temp\\test1.htm";
            if (!htmlDoc.loadFromFile(sFile)) {
                System.out.println("Failed to analyze Html Document.");
            } else {
                System.out.println("OK to analyze Html Document.");
                System.out.println(htmlDoc.toString());
                System.out.println("\nTest for getElementsByName...");
                elements = htmlDoc.getElementsByName("FORM");
                for (int i = 0; i < elements.size(); ++i) {
                    element = (HtmlElement)elements.get(i);
                    System.out.println("\n" + element.toString());
                }
                elements.clear();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }
}

