/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.database;

import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DataType;
import com.trs.infra.util.database.SQLServerDB;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DamengDB
extends SQLServerDB {
    public static final DataType NVARCHAR = new DataType("NVARCHAR", 12, -4000);
    public static final DataType NCHAR = new DataType("CHAR", 1, -4000);
    public static final DataType NTEXT = new DataType("TEXT", -1, 16);
    public static final DataType TINYINT = new DataType("TINYINT", -6, 1);
    public static final DataType DATE = new DataType("DATE", 93, 8);
    public static final DataType TIME = new DataType("TIME", 93, 8);
    public static final DataType TIMESTAMP = new DataType("TIMESTAMP", 93, 8);
    public static final DataType INTEGER = new DataType("INTEGER", 4, 4);
    public static final DataType VARCHAR = new DataType("VARCHAR", 12, -4000);
    public static final DataType VARCHAR2 = new DataType("VARCHAR2", 12, -4000);
    public static final DataType DOUBLE = new DataType("DOUBLE", 8);
    public static final DataType DOUBLE2 = new DataType("DOUBLE PRECISION", 8);
    public static final DataType CLOB = new DataType("CLOB", 2005);
    private static final DataType[] m_allDataTypes = new DataType[]{CHAR, VARCHAR, NUMBER, DATE, TEXT, IMAGE, INT, FLOAT, DATETIME, SMALLINT, TIMESTAMP, INTEGER, NUMERIC, BIGINT, TINYINT, DECIMAL, NVARCHAR, CLOB, VARCHAR2, DOUBLE, DOUBLE2};
    private static final int TYPES_NVARCHAR = -9;

    @Override
    public DataType[] getAllDataTypes() {
        return m_allDataTypes;
    }

    public DamengDB() {
        super("Dameng", "dm.jdbc.driver.DmDriver");
    }

    public DamengDB(String _sName, String _sDriverClass) {
        super("Dameng", "dm.jdbc.driver.DmDriver");
    }

    @Override
    public String sqlGetNextId() {
        return null;
    }

    @Override
    public String sqlQueryTableInfos(String _sOwnerUser) {
        return null;
    }

    @Override
    public String sqlQueryTableInfo(String _sOwnerUser, String _sDBTableName) {
        return null;
    }

    @Override
    protected void registerDBInfo() {
        super.registerDBInfo();
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "int");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "timestamp");
        this.registerColumnType(92, "timestamp");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
    }

    @Override
    public String sqlAddField(String tableName, String fieldName, String fieldType, int maxLength, boolean _bNullable, String defaultValue, int scale) {
        DataType dataType = this.getDataType(fieldType);
        if (dataType == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(tableName.toUpperCase());
        sql.append(" add ").append(fieldName.toUpperCase());
        int nMaxLength = maxLength;
        switch (dataType.getType()) {
            case 2: 
            case 4: {
                sql.append(" int ");
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 6: {
                sql.append(" float ");
                nMaxLength = dataType.getMaxLength();
                break;
            }
            case 91: 
            case 93: {
                sql.append(" datetime ");
                break;
            }
            case -9: 
            case 12: {
                sql.append(" varchar ");
                break;
            }
        }
        if (dataType.isLengthDefinedByUser()) {
            sql.append('(').append(nMaxLength);
            if (scale > 0) {
                sql.append(',').append(scale);
            }
            sql.append(')');
        }
        if (defaultValue != null && defaultValue.trim().length() > 0) {
            sql.append(" DEFAULT ");
            if (dataType.isCharData()) {
                sql.append("'");
                sql.append(CMyString.filterForSQL(defaultValue));
                sql.append("'");
            } else {
                sql.append(defaultValue);
            }
        }
        return sql.toString();
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public boolean canWriteTextDirectly() {
        return false;
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, int p_nFieldIndex) throws CMyException {
        try {
            return p_rsData.getString(p_nFieldIndex);
        }
        catch (SQLException e) {
            throw new CMyException(40, "\u8bfb\u53d6\u5927\u5b57\u6bb5\u5185\u5bb9\u5931\u8d25.");
        }
    }

    @Override
    public String getClob(ResultSet p_rsData, boolean p_bJdbcIs2, String p_sFieldName) throws CMyException {
        try {
            return p_rsData.getString(p_sFieldName);
        }
        catch (SQLException e) {
            throw new CMyException(40, "\u8bfb\u53d6\u5927\u5b57\u6bb5\u5185\u5bb9\u5931\u8d25.");
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String p_sClobFieldName, String p_sValue) throws CMyException {
        if (p_sClobFieldName.length() < 1 || p_sTableName.length() < 1 || p_sWhere.length() < 1 || p_sIdFieldName.length() < 1) {
            throw new CMyException(10, "\u53c2\u6570\u65e0\u6548");
        }
        if (p_sValue == null) {
            return true;
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ").append(p_sClobFieldName);
        sql.append(" from ").append(p_sTableName);
        sql.append(" where ").append(p_sWhere);
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            pstmt = p_oConn.prepareStatement(sql.toString());
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                Clob clob = rsData.getClob(1);
                clob.setString(1L, p_sValue);
            }
            boolean clob = true;
            return clob;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sWhere, String p_sIdFieldName, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548");
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ");
        sql.append(p_asFieldsAndValues[0]);
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
        }
        sql.append(" from ");
        sql.append(p_sTableName);
        sql.append(" where ").append(p_sWhere);
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            int colIndex;
            pstmt = p_oConn.prepareStatement(sql.toString());
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                colIndex = 1;
                for (int i = 1; i < length; i += 2) {
                    String value = p_asFieldsAndValues[i];
                    if (value == null) {
                        value = "";
                    }
                    Clob clob = rsData.getClob(colIndex++);
                    clob.setString(1L, value);
                }
            }
            colIndex = 1;
            return colIndex != 0;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean setClob(Connection p_oConn, String p_sTableName, String p_sIdFieldName, int nObjId, String[] p_asFieldsAndValues) throws CMyException {
        int length = p_asFieldsAndValues.length;
        if ((length & 1) != 0) {
            throw new CMyException(10, "CLOB\u5b57\u6bb5\u540d\u548c\u5b57\u6bb5\u503c\u6570\u7ec4\u53c2\u6570\u65e0\u6548");
        }
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ");
        sql.append(p_asFieldsAndValues[0]);
        for (int i = 2; i < length; i += 2) {
            sql.append(',').append(p_asFieldsAndValues[i]);
        }
        sql.append(" from ");
        sql.append(p_sTableName);
        sql.append(" where ").append(p_sIdFieldName);
        sql.append("=?");
        PreparedStatement pstmt = null;
        ResultSet rsData = null;
        try {
            int colIndex;
            pstmt = p_oConn.prepareStatement(sql.toString());
            pstmt.setInt(1, nObjId);
            rsData = pstmt.executeQuery();
            if (rsData.next()) {
                colIndex = 1;
                for (int i = 1; i < length; i += 2) {
                    String value = p_asFieldsAndValues[i];
                    if (value == null) {
                        value = "";
                    }
                    Clob clob = rsData.getClob(colIndex++);
                    clob.setString(1L, value);
                }
            }
            colIndex = 1;
            return colIndex != 0;
        }
        catch (SQLException ex) {
            throw new CMyException(40, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        catch (Exception ex) {
            throw new CMyException(0, "\u5199\u5165CLOB\u5b57\u6bb5\u65f6\u51fa\u9519", ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected String keywordsModifyField() {
        return "MODIFY";
    }

    @Override
    public String sqlRenameField(String _sTableName, String _sOldFieldName, String _sNewFieldName) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(_sTableName.toUpperCase());
        sql.append(" alter column ");
        sql.append(_sOldFieldName.toUpperCase());
        sql.append(" rename  to ");
        sql.append(_sNewFieldName.toUpperCase());
        return sql.toString();
    }

    @Override
    public String sqlRenameTable(String _sOldTableName, String _sNewTableName) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("alter table ");
        sql.append(_sOldTableName.toUpperCase());
        sql.append(" rename to ");
        sql.append(_sNewTableName.toUpperCase());
        return sql.toString();
    }
}

