/*
 * Decompiled with CFR 0.152.
 */
package com.trs.exchange.metadata;

import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;

public class WebSiteConstants {
    private static int WEBSITE_METAVIEW_ID;
    private static String SHOST;
    private static int[] WEBSITE_VIEWDATA_STATUS_TOBECOMPILED;
    public static int[] WEBSITE_VIEWDATA_STATUS_EDITED;
    public static int[] WEBSITE_VIEWDATA_STATUS_PUBLISHED;
    public static int[] WEBSITE_VIEWDATA_STATUS_NO;
    public static String PLATFORM_DAIBIAN;
    public static String PLATFORM_DAISHEN;
    public static String PLATFORM_YIQIANFA;

    public static String getSHost() throws WCMException {
        SHOST = ConfigServer.getServer().getSysConfigValue("WCM_UPLOAD_PATH", "");
        if (CMyString.isEmpty(SHOST)) {
            throw new WCMException("\u8bf7\u914d\u7f6e\u670d\u52a1\u5668\u5730\u5740\u53d8\u91cf\u3010WCM_UPLOAD_PATH\u3011");
        }
        return SHOST;
    }

    public static int getWebSiteMetaViewId() throws WCMException {
        WEBSITE_METAVIEW_ID = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("WEBSITE_METAVIEW_ID", "0"));
        return WEBSITE_METAVIEW_ID;
    }

    public static MetaView getWebSiteMetaView() throws WCMException {
        MetaView oWebSiteMetaView = MetaView.findById(WebSiteConstants.getWebSiteMetaViewId());
        if (oWebSiteMetaView == null) {
            throw new WCMException("APP\u7ad9\u70b9\u89c6\u56fe\u6ca1\u6709\u5728\u7cfb\u7edf\u4e2d\u521d\u59cb\u5316!");
        }
        return oWebSiteMetaView;
    }

    public static int[] getToBeCompiledDocStatus() throws WCMException {
        String sToBeCompiledDocStatus = ConfigServer.getServer().getSysConfigValue("WEBSITE_VIEWDATA_STATUS_TOBECOMPILED", "1");
        WEBSITE_VIEWDATA_STATUS_TOBECOMPILED = CMyString.splitToInt(sToBeCompiledDocStatus, ",");
        return WEBSITE_VIEWDATA_STATUS_TOBECOMPILED;
    }

    public static String getPlatformDesc(int _nStatusId) {
        try {
            if (WebSiteConstants.isInStatusArray(WebSiteConstants.getToBeCompiledDocStatus(), _nStatusId)) {
                return PLATFORM_DAIBIAN;
            }
            if (WebSiteConstants.isInStatusArray(WEBSITE_VIEWDATA_STATUS_EDITED, _nStatusId)) {
                return PLATFORM_DAISHEN;
            }
            return PLATFORM_YIQIANFA;
        }
        catch (WCMException e) {
            return "";
        }
    }

    private static boolean isInStatusArray(int[] _arrStatus, int _nStatusId) {
        for (int i = 0; i < _arrStatus.length; ++i) {
            if (_nStatusId != _arrStatus[i]) continue;
            return true;
        }
        return false;
    }

    static {
        WEBSITE_VIEWDATA_STATUS_EDITED = new int[]{2};
        WEBSITE_VIEWDATA_STATUS_PUBLISHED = new int[]{10};
        WEBSITE_VIEWDATA_STATUS_NO = new int[]{15};
        PLATFORM_DAIBIAN = "\u5f85\u7f16";
        PLATFORM_DAISHEN = "\u5f85\u5ba1";
        PLATFORM_YIQIANFA = "\u5df2\u7b7e\u53d1";
    }
}

