/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.eprobiti.trs.TRSHitPoint;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.CMyString;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class TRSSearchUtil {
    private static Logger logger = Logger.getLogger(TRSSearchUtil.class);
    public static final char[] MARK_CHARS = new char[]{',', '.', ';', '?', '!', '\uff0c', '\u3002', '\uff1b', '\uff1f', '\uff01', '\n', '\r', '\u3001', ' ', '\u3000', '\ue5d9'};

    public static String getStringWithCutsize(String value, TRSHitPoint[] hitPoints, int cutsize, String strHitColorValue, String charset) {
        logger.debug((Object)("hitPoints:" + hitPoints));
        logger.debug((Object)("cutsize:" + cutsize));
        logger.debug((Object)("strHitColorValue:" + strHitColorValue));
        logger.debug((Object)("charset:" + charset));
        long timeStart = System.currentTimeMillis();
        StringBuffer sb = null;
        String head = null;
        String tail = null;
        String tempStr = null;
        boolean headCut = false;
        boolean tailCut = false;
        try {
            char c;
            int i;
            int firstIndex = 0;
            int cutBegin = 0;
            int cutEnd = 0;
            int hitLength = 0;
            byte[] bytesValue = null;
            if (hitPoints != null && hitPoints.length != 0) {
                firstIndex = hitPoints[0].iStart;
                hitLength = hitPoints[0].iLength + hitPoints[0].iBlank;
                bytesValue = value.getBytes(charset);
                head = new String(bytesValue, 0, firstIndex, charset);
                tail = new String(bytesValue, firstIndex + hitLength, bytesValue.length - (firstIndex + hitLength), charset);
            } else {
                bytesValue = value.getBytes(charset);
                head = "";
                tail = new String(bytesValue, charset);
            }
            int tailCutsize = cutsize;
            if (head.length() <= cutsize / 2) {
                cutBegin = 0;
                tailCutsize = cutsize - head.length();
            } else {
                for (i = head.length() - cutsize / 2; i >= 0; --i) {
                    c = value.charAt(i);
                    if (!TRSSearchUtil.isMark(c)) continue;
                    cutBegin = i;
                    break;
                }
                if (cutBegin != 0) {
                    cutBegin = head.substring(0, cutBegin + 1).getBytes(charset).length;
                    headCut = true;
                    tailCutsize = cutsize / 2;
                } else {
                    tailCutsize = cutsize - head.length();
                }
            }
            logger.debug((Object)("tailCutsize:" + tailCutsize));
            if (tailCutsize < 0) {
                tailCutsize = 0;
            }
            logger.debug((Object)("tail.length():" + tail.length()));
            logger.debug((Object)("tailCutsize:" + tailCutsize));
            if (tail.length() <= tailCutsize) {
                cutEnd = bytesValue.length;
            } else {
                cutEnd = tail.length() - 1;
                for (i = tailCutsize; i < tail.length(); ++i) {
                    c = tail.charAt(i);
                    if (!TRSSearchUtil.isMark(c)) continue;
                    cutEnd = i;
                    break;
                }
                if ((cutEnd = firstIndex + hitLength + tail.substring(0, cutEnd + 1).getBytes(charset).length) != tail.length() - 1) {
                    tailCut = true;
                }
            }
            logger.debug((Object)("cutBegin:" + cutBegin));
            logger.debug((Object)("cutEnd:" + cutEnd));
            sb = new StringBuffer((int)(1.2 * (double)(cutEnd - cutBegin)));
            int lastIndex = cutBegin;
            for (int i2 = 0; hitPoints != null && i2 < hitPoints.length; ++i2) {
                if (i2 == 0) {
                    if (hitPoints[i2].iStart > cutEnd) {
                        sb.append(CMyString.transDisplay(TRSSearchUtil.ignoreImageTagHead(new String(bytesValue, lastIndex, cutEnd - lastIndex, charset)), false));
                        lastIndex = cutEnd;
                        break;
                    }
                    sb.append(CMyString.transDisplay(TRSSearchUtil.ignoreImageTagHead(new String(bytesValue, lastIndex, hitPoints[i2].iStart - lastIndex, charset)), false));
                } else {
                    if (hitPoints[i2].iStart > cutEnd) {
                        sb.append(CMyString.transDisplay(new String(bytesValue, lastIndex, cutEnd - lastIndex, charset), false));
                        lastIndex = cutEnd;
                        break;
                    }
                    sb.append(CMyString.transDisplay(new String(bytesValue, lastIndex, hitPoints[i2].iStart - lastIndex, charset), false));
                }
                tempStr = CMyString.transDisplay(new String(bytesValue, hitPoints[i2].iStart, hitPoints[i2].iLength + hitPoints[i2].iBlank, charset), false);
                if (hitPoints[i2].iStart + hitPoints[i2].iLength + hitPoints[i2].iBlank > cutEnd) {
                    sb.append(tempStr);
                    break;
                }
                sb.append("<font color=\"");
                sb.append(strHitColorValue);
                sb.append("\">");
                sb.append(tempStr);
                sb.append("</font>");
                lastIndex = hitPoints[i2].iStart + hitPoints[i2].iLength + hitPoints[i2].iBlank;
            }
            if (lastIndex < cutEnd) {
                tempStr = TRSSearchUtil.ignoreImageTagTail(new String(bytesValue, lastIndex, cutEnd - lastIndex, charset));
                sb.append(CMyString.transDisplay(tempStr, false));
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        String strReturn = sb.toString();
        if (headCut) {
            strReturn = "..." + strReturn;
        }
        if (tailCut) {
            strReturn = strReturn + "...";
        }
        long timeEnd = System.currentTimeMillis();
        logger.debug((Object)(I18NMessage.get(TRSSearchUtil.class, "TRSSearchUtil.label1", "getCutSize \u8017\u65f6:") + (timeEnd - timeStart)));
        return strReturn;
    }

    public static boolean isMark(char pC) {
        char[] chars = MARK_CHARS;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != pC) continue;
            return true;
        }
        return false;
    }

    private static String ignoreImageTagTail(String outStr) {
        if (outStr.length() > "<image".length() && outStr.substring(outStr.length() - "<image".length()).equalsIgnoreCase("<image")) {
            outStr = outStr.substring(0, outStr.length() - "<image".length());
        } else if (outStr.length() > "<image src=\"".length()) {
            String lastExt;
            int index;
            int lastLength = outStr.length();
            if (lastLength > 20) {
                lastLength = 20;
            }
            if ((index = (lastExt = outStr.substring(outStr.length() - lastLength).toLowerCase()).lastIndexOf("<image src=\"")) != -1 && outStr.lastIndexOf(62) < index) {
                outStr = outStr.substring(0, outStr.length() - lastExt.length() + index);
            }
        }
        return outStr;
    }

    private static String ignoreImageTagHead(String outStr) {
        int index = 0;
        if (outStr.length() > "src=".length() && outStr.substring(0, "src=".length()).equalsIgnoreCase("src=") && (index = outStr.indexOf(">")) != -1) {
            outStr = outStr.substring(index + 1);
        } else if (outStr.length() > "jpg\">".length()) {
            String picExt;
            int firstLength = outStr.length();
            if (firstLength > 6) {
                firstLength = 6;
            }
            if ((index = (picExt = outStr.substring(0, firstLength)).indexOf("\">")) != -1 && ("jpg".equals(picExt = picExt.substring(0, index).toLowerCase()) || "gif".equals(picExt) || "bmp".equals(picExt) || "png".equals(picExt) || "jpeg".equals(picExt) || "jpe".equals(picExt) || "jfif".equals(picExt) || "tif".equals(picExt) || "tiff".equals(picExt) || "ico".equals(picExt))) {
                outStr = outStr.substring(index + "\">".length());
            }
        }
        return outStr;
    }

    public static HashMap getFavorite(HttpServletRequest request) throws Exception {
        HashMap<String, String> retHashMap = new HashMap<String, String>();
        Cookie[] oCookies = request.getCookies();
        if (oCookies != null) {
            for (int i = 0; i < oCookies.length; ++i) {
                Cookie aCookie = oCookies[i];
                if (!aCookie.getName().equalsIgnoreCase("favPortalSearch")) continue;
                String sCookieValue = URLDecoder.decode(aCookie.getValue(), "utf-8");
                String[] sCookieItems = CMyString.split(sCookieValue, "|");
                if (sCookieItems == null) break;
                for (int j = 0; j < sCookieItems.length; ++j) {
                    String sItemValue;
                    String[] aCookieItemInfo = CMyString.split(sCookieItems[j], "$");
                    if (aCookieItemInfo == null || aCookieItemInfo.length <= 0) continue;
                    String sItemName = aCookieItemInfo[0];
                    String string = sItemValue = aCookieItemInfo.length > 1 ? aCookieItemInfo[1] : "";
                    if (sItemValue == null) {
                        sItemValue = "";
                    }
                    retHashMap.put(sItemName, sItemValue);
                }
                break;
            }
        }
        return retHashMap;
    }
}

