/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewDataMgr;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.ParameterError;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.util.CMyString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaViewDataMgr
implements IMetaViewDataMgr {
    private IMetaViewEmployerMgr m_oEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");

    @Override
    public CMSBaseObjs queryDatas(BaseChannel _oSiteOrChannel, WCMFilter _filter, int ... _pStatusIds) throws Exception {
        if (_oSiteOrChannel == null) {
            throw new ParameterError("\u6ca1\u6709\u6307\u5b9a\u7ad9\u70b9\u6216\u8005\u680f\u76ee");
        }
        if (_pStatusIds == null || _pStatusIds.length <= 0) {
            throw new ParameterError("\u6ca1\u6709\u6307\u5b9a\u72b6\u6001\uff01");
        }
        MetaView view = null;
        if (!_oSiteOrChannel.isSite()) {
            view = this.m_oEmployerMgr.getViewOfEmployer(_oSiteOrChannel);
        }
        boolean selectFromView = !_oSiteOrChannel.isSite() && view != null;
        String sDataTableName = this.findDataTableName(view);
        WCMFilter oFilter = new WCMFilter("WCMCHNLDOC", "", "");
        StringBuffer sbWhere = this.makeStatusWhere(oFilter, _pStatusIds);
        if (sbWhere.length() > 0) {
            sbWhere.append(" and ");
        }
        sbWhere.append(_oSiteOrChannel.isSite() ? "WCMChnlDoc.SiteId=?" : " WCMChnlDoc.ChnlId=?");
        oFilter.addSearchValues(_oSiteOrChannel.getId());
        if (selectFromView) {
            sbWhere.append(" and WCMChnlDoc.DocKind=? ");
            oFilter.addSearchValues(view.getId());
        }
        if (_filter.getFrom() != null && _filter.getFrom().toUpperCase().indexOf(sDataTableName) >= 0) {
            sbWhere.append(!selectFromView ? " and WCMChnlDoc.DocId=WCMDocument.DocId " : " and WCMChnlDoc.DocId=" + sDataTableName + ".MetaDataId ");
        }
        oFilter.setWhere(sbWhere.toString());
        oFilter.mergeWith(_filter);
        if (!selectFromView) {
            return this.openViewDocumentsNew(_oSiteOrChannel, oFilter);
        }
        this.replaceFieldForMetaView(oFilter);
        return MetaViewDatas.openWCMObjsNew(view, oFilter);
    }

    private StringBuffer makeStatusWhere(WCMFilter filter, int ... _pStatusIds) {
        StringBuffer sbWhere;
        if (_pStatusIds.length == 1) {
            switch (_pStatusIds[0]) {
                case 99999: {
                    sbWhere = new StringBuffer("WCMCHNLDOC.DOCSTATUS > ?");
                    filter.addSearchValues(0);
                    break;
                }
                case 88888: {
                    sbWhere = new StringBuffer("WCMCHNLDOC.DOCSTATUS > ? and WCMCHNLDOC.PUBSTATUS = ? ");
                    filter.addSearchValues(0);
                    filter.addSearchValues(MetaDataConstants.PubStatusEnum.TIMINGPUBLISHED.value);
                    break;
                }
                case -99999: {
                    sbWhere = new StringBuffer("WCMCHNLDOC.DOCSTATUS < ?");
                    filter.addSearchValues(0);
                    break;
                }
                case 0: {
                    sbWhere = new StringBuffer("");
                    break;
                }
                default: {
                    sbWhere = new StringBuffer("WCMCHNLDOC.DOCSTATUS = ? and WCMCHNLDOC.PUBSTATUS in (?,?) ");
                    filter.addSearchValues(_pStatusIds[0]);
                    filter.addSearchValues(MetaDataConstants.PubStatusEnum.PUBLISHED.value);
                    filter.addSearchValues(MetaDataConstants.PubStatusEnum.NOTPUBLISHED.value);
                    break;
                }
            }
        } else {
            sbWhere = new StringBuffer("WCMCHNLDOC.DOCSTATUS in(");
            for (int i = 0; i < _pStatusIds.length; ++i) {
                sbWhere.append("?,");
                filter.addSearchValues(_pStatusIds[i]);
            }
            sbWhere.deleteCharAt(sbWhere.length() - 1);
            sbWhere.append(")").append(" and WCMCHNLDOC.PUBSTATUS = ? ");
            filter.addSearchValues(MetaDataConstants.PubStatusEnum.NOTPUBLISHED.value);
        }
        sbWhere.append(" and WCMCHNLDOC.MODAL > ? ");
        filter.addSearchValues(0);
        return sbWhere;
    }

    @Override
    public String findDataTableName(BaseChannel _oSiteOrChannel) throws Exception {
        if (_oSiteOrChannel.isSite()) {
            return "WCMDOCUMENT";
        }
        MetaView view = this.m_oEmployerMgr.getViewOfEmployer(_oSiteOrChannel);
        return this.findDataTableName(view);
    }

    private String findDataTableName(MetaView _view) {
        String sDataTableName = "WCMDOCUMENT";
        if (_view != null) {
            sDataTableName = _view.getTrueTableName();
        }
        sDataTableName = sDataTableName.toUpperCase();
        return sDataTableName;
    }

    @Override
    public CMSBaseObjs queryDatas(BaseChannel _oSiteOrChannel, WCMFilter _filter) throws Exception {
        return this.queryDatas(_oSiteOrChannel, _filter, 99999);
    }

    @Override
    public CMSBaseObjs queryDatas(Channels _channels, WCMFilter _filter, int ... _pStatusIds) throws Exception {
        if (_channels == null || _channels.isEmpty()) {
            return new ViewDocuments(null);
        }
        if (_channels.size() == 1) {
            return this.queryDatas((Channel)_channels.getAt(0), _filter, _pStatusIds);
        }
        MetaView view = this.m_oEmployerMgr.findOneAndSameViewOfEmployer(_channels);
        String sDataTableName = this.findDataTableName(view);
        WCMFilter oFilter = new WCMFilter("WCMCHNLDOC", "", "");
        StringBuffer sbWhere = this.makeStatusWhere(oFilter, _pStatusIds);
        sbWhere.append(" and WCMChnlDoc.ChnlId in(");
        int nSize = _channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)_channels.getAt(i);
            if (channel == null) continue;
            sbWhere.append("?,");
            oFilter.addSearchValues(channel.getId());
        }
        sbWhere.setLength(sbWhere.length() - 1);
        sbWhere.append(")");
        if (_filter.getFrom() != null && _filter.getFrom().toUpperCase().indexOf(sDataTableName) >= 0) {
            sbWhere.append(view == null ? " and WCMChnlDoc.DocId=WCMDocument.DocId " : " and WCMChnlDoc.DocId=" + sDataTableName + ".MetaDataId ");
        }
        if (view != null) {
            sbWhere.append(" and WCMChnlDoc.DocKind=? ");
            oFilter.addSearchValues(view.getId());
        }
        oFilter.setWhere(sbWhere.toString());
        oFilter.mergeWith(_filter);
        if (view == null) {
            return this.openViewDocumentsNew(null, oFilter);
        }
        this.replaceFieldForMetaView(oFilter);
        return MetaViewDatas.openWCMObjsNew(view, oFilter);
    }

    private void replaceFieldForMetaView(WCMFilter _oFilter) {
        if (!CMyString.isEmpty((String)_oFilter.getSelect())) {
            String sDocIdReg = "(?i)(^|[^a-zA-Z]+)(docid)([^a-zA-Z]+|$)";
            String sSelect = _oFilter.getSelect().replaceAll("(?i)(^|[^a-zA-Z]+)(docid)([^a-zA-Z]+|$)", "$1MetaDataId$3");
            String sDocChannelReg = "(?i)(^|[^a-zA-Z]+)(DocChannel)([^a-zA-Z]+|$)";
            sSelect = sSelect.replaceAll("(?i)(^|[^a-zA-Z]+)(DocChannel)([^a-zA-Z]+|$)", "$1ChannelId$3");
            _oFilter.setSelect(sSelect);
        }
    }

    private void replaceFieldForDocument(WCMFilter _oFilter) {
        if (!CMyString.isEmpty((String)_oFilter.getSelect())) {
            String sMetaDataIdReg = "(?i)(^|[^a-zA-Z]+)(MetaDataId)([^a-zA-Z]+|$)";
            String sSelect = _oFilter.getSelect().replaceAll("(?i)(^|[^a-zA-Z]+)(MetaDataId)([^a-zA-Z]+|$)", "$1docid$3");
            String sOriginMetaDataIdReg = "(?i)(^|[^a-zA-Z]+)(OriginMetaDataId)([^a-zA-Z]+|$)";
            sSelect = sSelect.replaceAll("(?i)(^|[^a-zA-Z]+)(OriginMetaDataId)([^a-zA-Z]+|$)", "$1docid$3");
            _oFilter.setSelect(sSelect);
        }
    }

    @Override
    public CMSBaseObjs queryDatas(Channels _channels, WCMFilter _filter) throws Exception {
        return this.queryDatas(_channels, _filter, 99999);
    }

    private ViewDocuments openViewDocumentsNew(BaseChannel _host, WCMFilter _filter) throws WCMException {
        ViewDocuments oViewDocuments = _host == null ? new ViewDocuments(null) : new ViewDocuments(null, _host);
        this.replaceFieldForDocument(_filter);
        oViewDocuments.setSelectFields(_filter.getExtSelect(), _filter.getSelect());
        if (!_filter.isLoadAll()) {
            oViewDocuments.setPageSize(_filter.getPageSize());
            oViewDocuments.setCurrPage(_filter.getCurrPage());
        }
        oViewDocuments.openViewDocuments(_filter);
        return oViewDocuments;
    }

    @Override
    public CMSBaseObjs queryDatasInRecyle(BaseChannel _oSiteOrChannel, WCMFilter _filter) throws Exception {
        return this.queryDatas(_oSiteOrChannel, _filter, -99999);
    }

    @Override
    public CMSBaseObjs queryDatasInRecyle(Channels _channels, WCMFilter _filter) throws Exception {
        return this.queryDatas(_channels, _filter, -99999);
    }

    public static void main(String[] args) {
        String[] pTestData;
        String sDocIdReg = "(?i)(^|[^a-zA-Z]+)(docid)([^a-zA-Z]+|$)";
        for (String sTestData : pTestData = new String[]{"DocId,test,My", "T, DocId,Test", "T,D,DocId"}) {
            System.out.println(sTestData);
            Matcher matcher = Pattern.compile(sDocIdReg).matcher(sTestData);
            System.out.println(matcher.groupCount());
            while (matcher.find()) {
                System.out.println(matcher.start(2) + "-" + matcher.end(2));
            }
            System.out.println(sTestData.replaceAll(sDocIdReg, "$1MyId$3"));
        }
    }
}

