/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.extract;

import com.trs.components.infoview.extract.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class DataTypeBuilder {
    private static final HashMap s_InnerTypes = new HashMap();
    private String m_sTargetURI;
    private String m_sTargetPrefix;
    private String m_sSchemaURI;
    private String m_sSchemaPrefix;
    private HashMap m_oTopElements;
    private HashMap m_oMapDataTyee;

    private void prepare(Element rootElement) {
        Namespace ns = null;
        this.m_sSchemaURI = "http://www.w3.org/2001/XMLSchema";
        this.m_sTargetURI = rootElement.attributeValue("targetNamespace");
        ns = rootElement.getNamespaceForURI(this.m_sTargetURI);
        this.m_sTargetPrefix = ns.getPrefix();
        ns = rootElement.getNamespaceForURI(this.m_sSchemaURI);
        this.m_sSchemaPrefix = ns.getPrefix();
        this.m_oTopElements = new HashMap();
        this.m_oMapDataTyee = new HashMap();
    }

    private void normalize() {
        Iterator itrTypes = this.m_oTopElements.values().iterator();
        while (itrTypes.hasNext()) {
            this.normalizeDataType((DataType)itrTypes.next());
        }
    }

    private void normalizeDataType(DataType dataType) {
        ArrayList list;
        if (dataType.isInnerType()) {
            return;
        }
        if (dataType.getRefName() != null && dataType.getRefType() == null) {
            DataType subType = this.getDefType(dataType.getRefName());
            dataType.setRefType(subType);
            this.normalizeDataType(subType);
            return;
        }
        if (dataType.getDataName() != null && dataType.getDataType() == null) {
            DataType subType = this.getDataType(dataType.getDataName());
            dataType.setDataType(subType);
            this.normalizeDataType(subType);
            return;
        }
        if (dataType.getBaseName() != null && dataType.getBaseType() == null) {
            DataType subType = this.getDataType(dataType.getBaseName());
            dataType.setBaseType(subType);
            this.normalizeDataType(subType);
        }
        if (dataType.isComplexType() && (list = dataType.getChildren()) != null) {
            Iterator subTypes = list.iterator();
            while (subTypes.hasNext()) {
                this.normalizeDataType((DataType)subTypes.next());
            }
        }
    }

    private DataType getDefType(String sRefName) {
        String name = sRefName.substring(this.m_sTargetPrefix.length() + 1);
        return (DataType)this.m_oTopElements.get(name);
    }

    private DataType getDataType(String sDataName) {
        String name = sDataName.substring(this.m_sTargetPrefix.length() + 1);
        return (DataType)this.m_oMapDataTyee.get(name);
    }

    public void build(Document document) {
        Element root = document.getRootElement();
        if (root != null) {
            this.prepare(root);
            Iterator iter = null;
            iter = root.elementIterator("element");
            while (iter.hasNext()) {
                this.iterateDataTypeElement((Element)iter.next(), null);
            }
            iter = root.elementIterator("simpleType");
            while (iter.hasNext()) {
                this.iterateTopSimpleType((Element)iter.next());
            }
            iter = root.elementIterator("complexType");
            while (iter.hasNext()) {
                this.iterateTopComplexType((Element)iter.next());
            }
            this.normalize();
        }
    }

    public DataType getSchema(String name) {
        return (DataType)this.m_oTopElements.get(name);
    }

    private void iterateDataTypeElement(Element xsdElement, DataType oParentDataType) {
        DataType dataType = null;
        String name = xsdElement.attributeValue("name");
        String type = xsdElement.attributeValue("type");
        String ref = xsdElement.attributeValue("ref");
        if (type != null) {
            String nillable;
            dataType = this.buildInnerType(type);
            if (dataType == null) {
                dataType = DataType.getSimpleType();
                dataType.setDataName(type);
            }
            if ((nillable = xsdElement.attributeValue("nillable")) != null) {
                dataType.setNillable(nillable);
            }
        } else if (ref != null) {
            dataType = DataType.getSimpleType();
            dataType.setRefName(ref);
        }
        if (dataType == null) {
            Element xsdComplexType;
            Element xsdSimpleType = xsdElement.element("simpleType");
            if (xsdSimpleType != null) {
                dataType = this.buildSimpleType(xsdSimpleType);
            }
            if ((xsdComplexType = xsdElement.element("complexType")) != null) {
                dataType = this.buildComplexType(xsdComplexType);
            }
        }
        if (dataType != null) {
            if (oParentDataType != null) {
                oParentDataType.addChild(dataType);
            } else {
                this.m_oTopElements.put(name, dataType);
            }
            dataType.setName(name);
        }
    }

    private void iterateTopComplexType(Element xsdElement) {
        String name = xsdElement.attributeValue("name");
        if (name == null) {
            return;
        }
        DataType dataType = this.buildComplexType(xsdElement);
        if (dataType != null) {
            dataType.setTypeName(name);
            this.m_oMapDataTyee.put(name, dataType);
        }
    }

    private void iterateTopSimpleType(Element xsdElement) {
        String name = xsdElement.attributeValue("name");
        if (name == null) {
            return;
        }
        DataType dataType = this.buildSimpleType(xsdElement);
        if (dataType != null) {
            dataType.setTypeName(name);
            this.m_oMapDataTyee.put(name, dataType);
        }
    }

    private DataType buildSimpleType(Element xsdElement) {
        String base;
        Element xsdRestriction = xsdElement.element("restriction");
        if (xsdRestriction != null && (base = xsdRestriction.attributeValue("base")) != null) {
            DataType baseType = this.buildInnerType(base);
            if (baseType != null) {
                this.buildSimpleType(baseType, xsdRestriction);
            } else {
                baseType = DataType.getSimpleType();
                baseType.setBaseName(base);
            }
            return baseType;
        }
        return null;
    }

    private void buildSimpleType(DataType baseType, Element xsdElement) {
        Element element = null;
        element = xsdElement.element("minLength");
        if (element != null) {
            baseType.setMinLength(Integer.parseInt(element.attributeValue("value")));
        }
        if ((element = xsdElement.element("maxLength")) != null) {
            baseType.setMaxLength(Integer.parseInt(element.attributeValue("value")));
        }
    }

    private DataType buildComplexType(Element xsdElement) {
        Element simpleContent;
        Element complexContent;
        Element schemaAll;
        DataType dataType = DataType.getComplexType();
        Element schemaSequence = xsdElement.element("sequence");
        if (schemaSequence != null) {
            Iterator itr = schemaSequence.elementIterator("element");
            while (itr.hasNext()) {
                this.iterateDataTypeElement((Element)itr.next(), dataType);
            }
        }
        if ((schemaAll = xsdElement.element("all")) != null) {
            Iterator itr = schemaAll.elementIterator("element");
            while (itr.hasNext()) {
                this.iterateDataTypeElement((Element)itr.next(), dataType);
            }
        }
        if ((complexContent = xsdElement.element("complexContent")) != null) {
            Element restriction;
            Element extension = complexContent.element("extension");
            if (extension != null) {
                dataType.setBaseName(extension.attributeValue("base"));
                schemaSequence = extension.element("sequence");
                if (schemaSequence != null) {
                    Iterator itr = schemaSequence.elementIterator("element");
                    while (itr.hasNext()) {
                        this.iterateDataTypeElement((Element)itr.next(), dataType);
                    }
                }
            }
            if ((restriction = complexContent.element("restriction")) != null) {
                dataType.setBaseName(restriction.attributeValue("base"));
            }
        }
        if ((simpleContent = xsdElement.element("simpleContent")) != null) {
            Element restriction;
            Element extension = simpleContent.element("extension");
            if (extension != null) {
                dataType.setBaseName(extension.attributeValue("base"));
                this.buildSimpleType(dataType, extension);
            }
            if ((restriction = simpleContent.element("restriction")) != null) {
                dataType.setBaseName(restriction.attributeValue("base"));
                this.buildSimpleType(dataType, restriction);
            }
        }
        return dataType;
    }

    private DataType buildInnerType(String name) {
        DataType dataType = null;
        String type = (String)s_InnerTypes.get(name);
        if (type != null) {
            dataType = DataType.getInnerType();
        }
        if (name.startsWith(this.m_sSchemaPrefix)) {
            type = name.substring(this.m_sSchemaPrefix.length() + 1);
            dataType = DataType.getInnerType();
        }
        if (dataType != null) {
            dataType.setBaseName(type);
        }
        return dataType;
    }

    static {
        s_InnerTypes.put("any", "any");
        s_InnerTypes.put("anyURI", "anyURI");
        s_InnerTypes.put("base64Binary", "base64Binary");
        s_InnerTypes.put("boolean", "boolean");
        s_InnerTypes.put("date", "date");
        s_InnerTypes.put("integer", "integer");
        s_InnerTypes.put("string", "string");
    }
}

