/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.DreamFactory;
import com.trs.components.infoview.db.InfoViewDBStoreServer;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnBeforeAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyString;
import com.trs.service.IInfoViewService;
import com.trs.service.ServiceHelper;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;

public class DocumentLCListenerForInfoViewDB
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify,
IObjectLCListenerOnBeforeAdd {
    private static final Logger s_logger = Logger.getLogger(DocumentLCListenerForInfoViewDB.class);
    private InfoViewDBStoreServer m_oInfoViewDBStoreServer = null;

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof com.trs.components.wcm.content.persistent.Document)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label2", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)_oObjModified;
        if (!this.isInfoViewData(document)) {
            return;
        }
        this.getInfoViewDBStoreServer().saveInfoViewData(document.getFlag(), document);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof com.trs.components.wcm.content.persistent.Document)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)_oObjDeleted;
        if (!this.isInfoViewData(document)) {
            return;
        }
        this.getInfoViewDBStoreServer().deleteInfoViewData(document.getFlag(), document);
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof com.trs.components.wcm.content.persistent.Document)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label4", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)_oObjAdded;
        if (!this.isInfoViewData(document)) {
            return;
        }
        this.getInfoViewDBStoreServer().saveInfoViewData(document.getFlag(), document);
    }

    private boolean isInfoViewData(com.trs.components.wcm.content.persistent.Document document) {
        return document.getFlag() > 0;
    }

    private InfoViewDBStoreServer getInfoViewDBStoreServer() throws WCMException {
        if (this.m_oInfoViewDBStoreServer == null) {
            this.m_oInfoViewDBStoreServer = (InfoViewDBStoreServer)DreamFactory.createObjectById("InfoViewDBStoreServer");
        }
        if (this.m_oInfoViewDBStoreServer == null) {
            throw new WCMException(I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label5", "\u5bf9\u4e0d\u8d77\uff0c\u65e0\u6cd5\u627e\u5230\u7a00\u758f\u6570\u636e\u5e94\u7528\uff01\u8bf7\u68c0\u67e5\u60a8\u7684WCM\uff01"));
        }
        return this.m_oInfoViewDBStoreServer;
    }

    @Override
    public void notifyOnBeforeAddObj(BaseObj objAdded) throws WCMException {
        Node serialNode;
        if (!(objAdded instanceof com.trs.components.wcm.content.persistent.Document)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + objAdded.getClass() + I18NMessage.get(DocumentLCListenerForInfoViewDB.class, "DocumentLCListenerForInfoViewDB.label4", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)objAdded;
        if (!this.isInfoViewData(document)) {
            return;
        }
        String sContent = document.getContent();
        IInfoViewService oInfoViewService = ServiceHelper.createInfoViewService();
        Document dom4jDocument = oInfoViewService.getDOM4JDocument(sContent);
        InfoView oInfoview = InfoView.findById(document.getFlag());
        if (oInfoview == null || !oInfoview.hasDocSerial()) {
            return;
        }
        String serial = oInfoViewService.getInfoViewSerial(oInfoview);
        document.setProperty("DOCNO", serial);
        String serialField = oInfoview.getSerialField();
        if (!CMyString.isEmpty(serialField) && (serialNode = dom4jDocument.selectSingleNode("//" + serialField)) != null) {
            serialNode.setText(serial);
        }
        document.setContent(dom4jDocument.asXML());
        String sTitle = document.getTitle();
        IInfoViewService infoviewService = this.getInfoViewService();
        sTitle = infoviewService.getDocumentTitle(oInfoview, dom4jDocument);
        if (!CMyString.isEmpty(sTitle) && document.getOutUpId() <= 0) {
            document.setTitle(sTitle);
        }
    }

    private IInfoViewService getInfoViewService() throws WCMException {
        try {
            return ServiceHelper.createInfoViewService();
        }
        catch (WCMException ex) {
            throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u65e0\u6cd5\u627e\u5230\u81ea\u5b9a\u4e49\u8868\u5355\u5e94\u7528\uff01\u8bf7\u68c0\u67e5\u60a8\u7684WCM\uff01");
        }
    }
}

