/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyBitsValue;

public class Rights
extends CMSBaseObjs {
    public Rights(User _currUser) {
        super(_currUser);
    }

    public Rights(User _currUser, int initialCapacity, int capacityIncrement) {
        super(_currUser, initialCapacity, capacityIncrement);
    }

    @Override
    protected String getDbTableName() {
        return "WCMRIGHT";
    }

    @Override
    public String getIdFieldName() {
        return "RIGHTID";
    }

    @Override
    public Class getElementClass() {
        return Right.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new Rights(this.currUser);
    }

    public CMyBitsValue orAll() {
        CMyBitsValue myBitsValue = null;
        Right right = null;
        for (int i = 0; i < this.size(); ++i) {
            right = (Right)this.getAt(i);
            if (right == null) continue;
            if (myBitsValue == null) {
                myBitsValue = new CMyBitsValue(right.getValue());
                continue;
            }
            myBitsValue.or(right.getValue());
        }
        return myBitsValue;
    }

    public int indexOf(CMSObj _operator, CMSObj _obj) {
        if (_operator == null || !_operator.isValidInstance() || _obj == null || !_obj.isValidInstance()) {
            return -1;
        }
        return this.indexOf(_operator.getWCMType(), _operator.getId(), _obj.getWCMType(), _obj.getId());
    }

    public int indexOf(int _operatorType, int _operatorId, int _objType, int _objId) {
        Right right = null;
        for (int i = 0; i < this.size(); ++i) {
            right = (Right)this.getAt(i);
            if (right == null || right.getOperatorType() != _operatorType || right.getOperatorId() != _operatorId || right.getObjType() != _objType || right.getObjId() != _objId) continue;
            return i;
        }
        return -1;
    }

    public static final Rights findByIds(User _currUser, String _sIds) throws WCMException {
        if (_sIds.length() <= 0) {
            throw new WCMException(10, I18NMessage.get(Rights.class, "Rights.label1", "\u6307\u5b9a\u5bf9\u8c61ID\u5e8f\u5217\u65e0\u6548\uff01"));
        }
        return (Rights)CMSBaseObjs.findWCMObjsByIds(_currUser, Rights.class, _sIds);
    }

    public static final Rights openWCMObjs(User _currUser, WCMFilter _filter) throws WCMException {
        return (Rights)CMSBaseObjs.openWCMObjs(_currUser, Rights.class, _filter);
    }

    public static Rights createNewInstance(User _currUser) throws WCMException {
        return (Rights)CMSBaseObjs.createInstance(_currUser, Rights.class);
    }
}

