/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowEngineHelper;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FlowContentsToXML
implements IXMLConvertor {
    private static Logger logger = Logger.getLogger(FlowContentsToXML.class);

    @Override
    public String[] registerTargetClassName() {
        IFlowContent[] flowContents = new IFlowContent[]{};
        return new String[]{flowContents.getClass().getName()};
    }

    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        try {
            Element elRoot = null;
            if (_result instanceof IFlowContent[]) {
                IFlowContent[] pFlowContents = (IFlowContent[])_result;
                int nPageSize = -1;
                int nPageIndex = 1;
                if (_methodContext != null) {
                    nPageSize = _methodContext.getValue("PAGESIZE", -1);
                    nPageIndex = _methodContext.getPageIndex();
                }
                elRoot = DocumentHelper.createElement((String)"FlowContents");
                CPager currPager = new CPager(nPageSize);
                currPager.setCurrentPageIndex(nPageIndex);
                currPager.setItemCount(pFlowContents.length);
                this.setPageAttributes(currPager, elRoot);
                for (int i = currPager.getFirstItemIndex(); i <= currPager.getLastItemIndex(); ++i) {
                    IFlowContent flowContent = pFlowContents[i - 1];
                    if (flowContent == null) continue;
                    elRoot.add(this.toXMLElement(_methodContext, flowContent));
                }
            } else if (_result instanceof IFlowContent) {
                elRoot = this.toXMLElement(_methodContext, (IFlowContent)_result);
            } else {
                throw new ConvertException(I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label1", "\u4e0d\u652f\u6301\u7684\u7c7b\u578b[") + _result.getClass().getName() + "]!");
            }
            return elRoot.asXML();
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label2", "\u5c06FlowContent\u8f6c\u6362\u4e3aXML\u5931\u8d25"), e);
        }
    }

    private void setPageAttributes(CPager _pager, Element _element) {
        _element.addAttribute("Num", String.valueOf(_pager.getItemCount()));
        if (_pager.getPageSize() <= 0) {
            return;
        }
        _element.addAttribute("PageSize", String.valueOf(_pager.getPageSize()));
        _element.addAttribute("PageCount", String.valueOf(_pager.getPageCount()));
        _element.addAttribute("CurrPageIndex", String.valueOf(_pager.getCurrentPageIndex()));
    }

    private Element toXMLElement(MethodContext _methodContext, IFlowContent _flowContent) throws WCMException {
        Element elContent = DocumentHelper.createElement((String)"FlowContent");
        elContent.addElement("Title").addCDATA(CMyString.transDisplay(_flowContent.getDesc()));
        elContent.addElement("ContentType").addText(String.valueOf(_flowContent.getContentType()));
        elContent.addElement("ContentId").addText(String.valueOf(_flowContent.getId()));
        elContent.addElement("DeletePage").addCDATA(_flowContent.getDeletePage());
        elContent.addElement("EditPage").addCDATA(_flowContent.getContentAddEditPage());
        elContent.addElement("ShowPage").addCDATA(_flowContent.getContentShowPage());
        elContent.addElement("Status").addCDATA(_flowContent.getStatusDesc());
        elContent.addElement("CrUser").addCDATA(_flowContent.getSubinstance().getCrUserName());
        elContent.addElement("CrTime").addCDATA(this.convertDateTimeValueToString(_methodContext, _flowContent.getSubinstance().getCrTime()));
        if (_flowContent.getStartTime() != null) {
            elContent.addElement("StartTime").addCDATA(this.convertDateTimeValueToString(_methodContext, _flowContent.getStartTime()));
        }
        elContent.addElement("ProcessInfo").addCDATA(this.makeProcessInfo(_flowContent.getFlowDoc()));
        elContent.addElement("IsEnd").addText(_flowContent.getFlowDoc() == null ? "1" : "0");
        if (_flowContent.getFlowDoc() != null) {
            FlowDoc currFlowDoc = _flowContent.getFlowDoc();
            elContent.addElement("FlowDocId").addText(String.valueOf(currFlowDoc.getId()));
            elContent.addElement("PostUser").addCDATA(currFlowDoc.getRealPostUserNames());
            User postUser = currFlowDoc.getPostUser();
            String sPostUserIds = null;
            sPostUserIds = postUser == null ? "0" : String.valueOf(postUser.getId());
            elContent.addElement("PostUserId").addCDATA(sPostUserIds);
            elContent.addElement("PostTime").addCDATA(this.convertDateTimeValueToString(_methodContext, currFlowDoc.getPostTime()));
            elContent.addElement("ToUsers").addCDATA(currFlowDoc.getToUserNames());
            elContent.addElement("FlagId").addText(String.valueOf(currFlowDoc.getFlag()));
            elContent.addElement("FlagDesc").addText(currFlowDoc.getFlagDesc());
            elContent.addElement("Reworked").addText(currFlowDoc.getFlag() == 2 ? "1" : "0");
            elContent.addElement("Received").addText(currFlowDoc.isReceived() ? "1" : "0");
            elContent.addElement("Accepted").addText(currFlowDoc.isAccepted() ? "1" : "0");
            elContent.addElement("Worked").addText(currFlowDoc.isWorked() ? "1" : "0");
            elContent.addElement("WorkModal").addText(String.valueOf(currFlowDoc.getWorkModal()));
            FlowNode currNode = currFlowDoc.getNode();
            if (currNode != null) {
                elContent.addElement("NodeId").addText(String.valueOf(currNode.getId()));
                elContent.addElement("NodeName").addText(String.valueOf(currNode.getName()));
            }
            User loginUser = ContextHelper.getLoginUser();
            int nRightValue = 0;
            if (currNode != null && !currFlowDoc.isWorked() && loginUser.getId() == currFlowDoc.getToUserId()) {
                nRightValue = currNode.getDocActionsAsInt();
            }
            elContent.addElement("Right").addText(String.valueOf(nRightValue));
            Element elComments = elContent.addElement("Comments");
            String[] pComments = FlowEngineHelper.parseComments(currFlowDoc);
            if (pComments != null) {
                for (int i = 0; i < pComments.length; ++i) {
                    Element elComment = elComments.addElement("Comment");
                    elComment.addElement("User").addCDATA(pComments[i]);
                    elComment.addElement("Content").addCDATA(pComments[++i]);
                }
            }
        }
        return elContent;
    }

    private String makeProcessInfo(FlowDoc _flowDoc) throws WCMException {
        if (_flowDoc == null) {
            return I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label3", "\u6d41\u8f6c\u7ed3\u675f");
        }
        String sDateFormat = I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label4", "yy\u5e74MM\u6708dd\u65e5 HH:mm");
        if (_flowDoc.getToUserId() > 0) {
            if (_flowDoc.isWorked()) {
                return _flowDoc.getPostUserName() + "[" + _flowDoc.getPostTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label6", "\u7684\u4e8b\u60c5\u5df2\u4e8e[") + _flowDoc.getPropertyAsDateTime("WorkTime").toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label7", "]\u5904\u7406\u5b8c\u6210\uff01");
            }
            if (_flowDoc.isReceived()) {
                if (_flowDoc.isAccepted()) {
                    return _flowDoc.getPostUserName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + _flowDoc.getPostTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label9", "\u5904\u7406\uff0c") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + _flowDoc.getAcceptTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label10", "]\u51b3\u5b9a\u5f00\u59cb\u5904\u7406");
                }
                return _flowDoc.getPostUserName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + _flowDoc.getPostTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label9", "\u5904\u7406\uff0c") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + _flowDoc.getReceiveTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label11", "]\u6536\u5230\uff0c\u4f46\u5c1a\u672a\u51b3\u5b9a\u662f\u5426\u5904\u7406");
            }
            return _flowDoc.getPostUserName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + _flowDoc.getPostTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label12", "\u5904\u7406\uff0c\u4f46") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label13", "\u5c1a\u672a\u6536\u5230");
        }
        if (CMyString.isEmpty(_flowDoc.getToUserIds())) {
            return "";
        }
        FlowDocs flowDocs = _flowDoc.getChildren(null, null);
        StringBuffer sbResult = new StringBuffer(flowDocs.size() * 200);
        sbResult.append(_flowDoc.getPostUserName() + "[" + _flowDoc.getPostTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label5", "]\u4ea4\u7ed9") + _flowDoc.getToUserNames() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label15", "\u7684\u4e8b\u60c5 "));
        boolean bFirst = true;
        int nSize = flowDocs.size();
        for (int i = 0; i < nSize; ++i) {
            User toUser;
            FlowDoc childFlowDoc = (FlowDoc)flowDocs.getAt(i);
            if (childFlowDoc == null || (toUser = childFlowDoc.getToUser()) == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append("\uff1b");
            }
            if (childFlowDoc.isWorked()) {
                sbResult.append(toUser.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + childFlowDoc.getPropertyAsDateTime("WorkTime").toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label16", "]\u5904\u7406\u5b8c\u6210"));
                continue;
            }
            if (childFlowDoc.isReceived()) {
                if (childFlowDoc.isAccepted()) {
                    sbResult.append(toUser.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + childFlowDoc.getAcceptTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label10", "]\u51b3\u5b9a\u5f00\u59cb\u5904\u7406"));
                    continue;
                }
                sbResult.append(toUser.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label8", "\u5df2\u4e8e[") + childFlowDoc.getReceiveTime().toString(sDateFormat) + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label11", "]\u6536\u5230\uff0c\u4f46\u5c1a\u672a\u51b3\u5b9a\u662f\u5426\u5904\u7406"));
                continue;
            }
            sbResult.append(toUser.getName() + I18NMessage.get(FlowContentsToXML.class, "FlowContentsToXML.label13", "\u5c1a\u672a\u6536\u5230"));
        }
        return sbResult.toString();
    }

    private String convertDateTimeValueToString(MethodContext _methodContext, CMyDateTime _dtValue) {
        String sDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        if (_methodContext != null && (sDateTimeFormat = _methodContext.getValue("DateTimeFormat")) == null) {
            sDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        }
        String sDtValue = _dtValue.toString(sDateTimeFormat);
        return sDtValue;
    }

    public static void main(String[] args) {
        IFlowContent[] flowContents = new IFlowContent[3];
        System.out.println(flowContents.getClass().getName());
    }
}

