/*
 * Decompiled with CFR 0.152.
 */
package com.trs.crypt;

import com.trs.crypt.KeyException;
import com.trs.crypt.KeyInfo;
import com.trs.crypt.KeyJNIV124;

public class KeyAPI {
    protected KeyAPI() {
    }

    public static final KeyAPI getInstance() throws KeyException {
        int DLLErrorCode = KeyJNIV124.getDLLErrorCode();
        switch (DLLErrorCode) {
            case 0: {
                break;
            }
            case 1: {
                throw new KeyException("JNI library not found:" + KeyJNIV124.getDLLErrorString());
            }
            case 2: {
                throw new KeyException("JNI library found, but can't link:" + KeyJNIV124.getDLLErrorString());
            }
            case 3: {
                throw new KeyException("JNI library version mismatch");
            }
            default: {
                throw new KeyException("JNI library link error, unknown");
            }
        }
        Class cls = null;
        Object api = null;
        try {
            cls = KeyJNIV124.decryptClass(null, 0L, null, Thread.currentThread().getContextClassLoader(), null);
            api = cls.newInstance();
        }
        catch (Exception e) {
            throw new KeyException(e.getMessage());
        }
        return api;
    }

    public String identifyHost() throws KeyException {
        throw new KeyException("Illegal Call, only for JNI");
    }

    public String getLocalIPs() throws KeyException {
        throw new KeyException("Illegal Call, only for JNI");
    }

    public String getLocalMACs() throws KeyException {
        throw new KeyException("Illegal Call, only for JNI");
    }

    public String generateDemo(String Signature, String Product, String Version, String License, String Custom) throws KeyException {
        throw new KeyException("Illegal Call, only for JNI");
    }

    public KeyInfo validateCode(String Signature, String KeyIn) throws KeyException {
        return this.validateCode(Signature, KeyIn, false);
    }

    public KeyInfo validateCode(String Signature, String KeyIn, boolean IgnoreDeadline) throws KeyException {
        throw new KeyException("Illegal Call, only for JNI");
    }

    public Class decryptClass(String ClassName, byte[] ClassData, ClassLoader ClassLoader2) throws KeyException {
        throw new KeyException("Illegal Call, only for JNI");
    }

    public byte[] encryptClass(String ClassName, byte[] ClassData) throws KeyException {
        throw new KeyException("Illegal Call, only for JNI");
    }

    public static void main(String[] args) throws Exception {
        try {
            KeyAPI api = KeyAPI.getInstance();
            System.out.println(api.identifyHost());
        }
        catch (KeyException ex) {
            System.out.println(ex.getMessage());
            throw ex;
        }
    }
}

