/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.http.rfc1867.impl;

import com.trs.net.http.rfc1867.FormPart;
import com.trs.net.http.rfc1867.FormPartFactory;
import com.trs.net.http.rfc1867.ProgressMonitor;
import com.trs.net.http.rfc1867.RFC1867Request;
import com.trs.net.http.rfc1867.impl.FileFormPart;
import com.trs.net.http.rfc1867.impl.RFC1867Processer;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestV23
extends HttpServletRequestWrapper
implements RFC1867Request {
    private ProgressMonitor m_oProgress;
    private Hashtable m_oFormParts = null;
    private boolean m_zMultiForm = false;
    private FormPartFactory m_oFormPartFactory;

    public RequestV23(HttpServletRequest request) {
        super(request);
        String sContentType;
        if ("POST".equals(request.getMethod()) && (sContentType = request.getHeader("Content-Type")) != null && sContentType.startsWith("multipart/form-data")) {
            this.m_zMultiForm = true;
        }
    }

    public HttpServletRequest getOriginalRequest() {
        return (HttpServletRequest)super.getRequest();
    }

    public FormPartFactory getFormPartFactory() {
        return this.m_oFormPartFactory;
    }

    public void setFormPartFactory(FormPartFactory formpartfactory) {
        this.m_oFormPartFactory = formpartfactory;
    }

    public String getConvertCharset() {
        return null;
    }

    public void setConvertCharset(String s) {
    }

    public FormPart getFormPart(String s) {
        FormPart[] parts = this.getFormPartArray(s);
        if (parts != null) {
            return parts[0];
        }
        return null;
    }

    public FormPart[] getFormPartArray(String s) {
        FileFormPart part;
        if (this.m_zMultiForm && (part = (FileFormPart)this.getFormParts().get(s)) != null) {
            int iCount = part.m_iBrotherCount;
            FormPart[] parts = new FileFormPart[iCount];
            while (part != null) {
                parts[--iCount] = part;
                part = part.m_rfNextBrother;
            }
            return parts;
        }
        return null;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.m_oProgress;
    }

    public void setProgressMonitor(ProgressMonitor progress) {
        this.m_oProgress = progress;
    }

    private Hashtable getFormParts() {
        if (this.m_zMultiForm && this.m_oFormParts == null) {
            this.m_oFormParts = new Hashtable();
            RFC1867Processer p = new RFC1867Processer(this.m_oFormPartFactory);
            p.process(this.getOriginalRequest(), this.m_oFormParts, this.m_oProgress);
        }
        return this.m_oFormParts;
    }

    public String getParameter(String name) {
        if (this.m_zMultiForm) {
            String[] values = this.getParameterValues(name);
            if (values != null) {
                return values[0];
            }
            return null;
        }
        return super.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.m_zMultiForm) {
            return this.getFormParts();
        }
        return super.getParameterMap();
    }

    public Enumeration getParameterNames() {
        if (this.m_zMultiForm) {
            return this.getFormParts().keys();
        }
        return super.getParameterNames();
    }

    public String[] getParameterValues(String name) {
        if (this.m_zMultiForm) {
            FileFormPart part = (FileFormPart)this.getFormParts().get(name);
            if (part != null) {
                String enc = this.getCharacterEncoding();
                int iCount = part.m_iBrotherCount;
                String[] strValues = new String[iCount];
                while (part != null) {
                    String value = part.getString();
                    if (value == null && part.getBytes() != null) {
                        try {
                            value = new String(part.getBytes(), enc);
                            part.setString(value);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    strValues[--iCount] = value;
                    part = part.m_rfNextBrother;
                }
                return strValues;
            }
            return null;
        }
        return super.getParameterValues(name);
    }
}

