/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.view.controller.mission;

import com.trs.cis4.bean.User;
import com.trs.cis4.gateway.bean.AgentConfig;
import com.trs.cis4.gateway.helper.ConfigHelper;
import com.trs.cis4.gateway.logic.IConfigLogic;
import com.trs.cis4.gateway.logic.util.GWSysApplication;
import com.trs.cis4.gateway.view.controller.base.Simple_Form_Controller;
import com.trs.cis4.gateway.view.util.ClearSessionCache;
import com.trs.cis4.gateway.view.util.SaveMissionChangedLog;
import com.trs.cis4.util.ConstUtil;
import com.trs.cis4.util.DateTimeUtil;
import com.trs.cis4.util.ExceptionUtil;
import com.trs.cis4.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;

public class Task_Info_Show_Controller
extends Simple_Form_Controller {
    private Logger log4j = Logger.getLogger(((Object)((Object)this)).getClass());
    private IConfigLogic configLogic;
    private SaveMissionChangedLog saveMissionChangedLog;

    public ModelAndView _onSubmit(HttpServletRequest request, HttpServletResponse response, Object formObj, BindException ex) throws Exception {
        if (request.getParameter("selfView") != null) {
            return new ModelAndView(this.getSelfView());
        }
        if (request.getParameter("preView") != null) {
            return new ModelAndView(this.getPreView());
        }
        HttpSession session = request.getSession();
        StringBuffer log = (StringBuffer)session.getAttribute("LOG");
        User user = (User)session.getAttribute("user");
        AgentConfig agentConfig = new AgentConfig();
        String taskName = (String)session.getAttribute("taskName");
        if (taskName != null) {
            agentConfig = (AgentConfig)session.getAttribute(taskName);
        }
        String oldName = (String)session.getAttribute("oldTaskName");
        if (agentConfig.getId() != null) {
            String rdb_policy_update = (String)session.getAttribute("rdb_policy_update");
            if (rdb_policy_update != null && rdb_policy_update.equals("true")) {
                AgentConfig ac;
                try {
                    ac = this.configLogic.get(agentConfig.getTask_name());
                }
                catch (Exception e2) {
                    ac = null;
                }
                try {
                    this.getConfigLogic().edit(agentConfig, oldName);
                }
                catch (Exception e) {
                    this.log4j.error((Object)e.getLocalizedMessage());
                    if (ac != null) {
                        this.rollbackMission(user, ac);
                    }
                    throw new ExceptionUtil(1, "\u4fee\u6539\u4efb\u52a1\u53d1\u751f\u5f02\u5e38,\u56de\u6eda\u4efb\u52a1\u6210\u529f\uff01", e.getLocalizedMessage());
                }
                log.append("\r\n" + DateTimeUtil.getYMDHMSZFromDate((Date)new Date()) + " IP\u5730\u5740\uff1a" + request.getRemoteAddr() + " \u7528\u6237\u540d\uff1a" + user.getSysuser().getUserid() + " \u4fee\u6539\u4efb\u52a1\uff0c\u539f\u540d\u79f0\u3010" + oldName + "\u3011\u73b0\u5728\u540d\u79f0\u4e3a\u3010" + agentConfig.getTask_name() + "\u3011\uff0c\u6b64\u4efb\u52a1\u7684\u66f4\u65b0\u65b9\u5f0f\u4e3a\u589e\u91cf\u66f4\u65b0");
                session.removeAttribute("rdb_policy_update");
            } else {
                AgentConfig ac;
                try {
                    ac = this.configLogic.get(agentConfig.getTask_name());
                }
                catch (Exception e2) {
                    ac = null;
                }
                try {
                    this.getConfigLogic().delete(oldName);
                    this.getConfigLogic().add(agentConfig);
                }
                catch (Exception e) {
                    this.log4j.error((Object)e.getLocalizedMessage());
                    if (ac != null) {
                        this.rollbackMission(user, ac);
                    }
                    throw new ExceptionUtil(1, "\u4fee\u6539\u4efb\u52a1\u53d1\u751f\u5f02\u5e38,\u56de\u6eda\u4efb\u52a1\u6210\u529f\uff01", e.getLocalizedMessage());
                }
                log.append("\r\n" + DateTimeUtil.getYMDHMSZFromDate((Date)new Date()) + " IP\u5730\u5740\uff1a" + request.getRemoteAddr() + " \u7528\u6237\u540d\uff1a" + user.getSysuser().getUserid() + " \u4fee\u6539\u4efb\u52a1\uff0c\u539f\u540d\u79f0\u3010" + oldName + "\u3011\u73b0\u5728\u540d\u79f0\u4e3a\u3010" + agentConfig.getTask_name() + "\u3011");
            }
        } else {
            try {
                this.getConfigLogic().add(agentConfig);
            }
            catch (Exception e) {
                long time = System.currentTimeMillis();
                this.backUpMession(agentConfig, String.valueOf(time));
                throw new ExceptionUtil(1, "\u65b0\u5efa\u4efb\u52a1\u53d1\u751f\u5f02\u5e38", String.valueOf(e.getLocalizedMessage()) + "<br>\u7cfb\u7edf\u5df2\u505a\u597d\u5907\u4efd(%GW_HOME%/jsp/data/temp/backup" + time + ".xml)");
            }
            log.append("\r\n" + DateTimeUtil.getYMDHMSZFromDate((Date)new Date()) + " IP\u5730\u5740\uff1a" + request.getRemoteAddr() + " \u7528\u6237\u540d\uff1a" + user.getSysuser().getUserid() + " \u65b0\u5efa\u4efb\u52a1\u540d\u79f0\u4e3a\u3010" + agentConfig.getTask_name() + "\u3011");
        }
        this.getSaveMissionChangedLog().doLog(log.toString());
        ClearSessionCache.clearSessionCache(request);
        return new ModelAndView(this.getSuccessView());
    }

    private void rollbackMission(User user, AgentConfig ac) throws IOException, ExceptionUtil {
        try {
            this.getConfigLogic().add(ac);
            this.log4j.info((Object)("\u4fee\u6539\u4efb\u52a1\u5931\u8d25\uff0c\u56de\u6eda\u4efb\u52a1\u3010" + ac.getTask_name() + "\u3011\u6210\u529f"));
        }
        catch (Exception e2) {
            long time = System.currentTimeMillis();
            this.backUpMession(ac, String.valueOf(time));
            this.log4j.error((Object)("\u4fee\u6539\u4efb\u52a1\u5931\u8d25\uff0c\u56de\u6eda\u4efb\u52a1\u3010" + ac.getTask_name() + "\u3011\u4e5f\u5931\u8d25\uff0c\u7cfb\u7edf\u5df2\u505a\u597d\u5907\u4efd(%GW_HOME%/jsp/data/temp/backup" + time + ".xml)"));
            throw new ExceptionUtil(1, "\u4fee\u6539\u4efb\u52a1\u53d1\u751f\u5f02\u5e38,\u5c1d\u8bd5\u56de\u6eda\u53c8\u53d1\u751f\u4e86\u5f02\u5e38", String.valueOf(e2.getLocalizedMessage()) + "<br>\u7cfb\u7edf\u5df2\u505a\u597d\u5907\u4efd(%GW_HOME%/jsp/data/temp/backup" + time + ".xml)");
        }
    }

    public AgentConfig _formBackingObject(HttpServletRequest request) throws Exception {
        String isshowtab = request.getParameter("isshowtab");
        String taskName = request.getParameter("taskName");
        if (isshowtab != null && isshowtab.equals("no")) {
            request.setAttribute("taskNameNoSession", (Object)taskName);
        }
        AgentConfig agentConfig = this.getAgentConfig(request);
        return agentConfig;
    }

    private void backUpMession(AgentConfig agentConfig, String extname) {
        ArrayList<AgentConfig> agentConfigL = new ArrayList<AgentConfig>();
        agentConfigL.add(agentConfig);
        String fileName = "backup" + extname + ".xml";
        String content = ConfigHelper.objectsToString(agentConfigL);
        String folderPath = GWSysApplication.getSystemExecuteFolder_Temp();
        File fileP = new File(folderPath);
        if (!fileP.exists()) {
            FileUtil.createFolder((String)folderPath);
        }
        try {
            File file = new File(String.valueOf(folderPath) + ConstUtil.DIR_SEPERATOR + fileName);
            FileUtil.writeFile((File)file, (String)content, (String)"GBK");
        }
        catch (IOException e) {
            this.log4j.error((Object)("\u4fee\u6539\u975e\u589e\u91cf\u66f4\u65b0\u4efb\u52a1\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8fdb\u884c\u5907\u4efd\u7684\u8fc7\u7a0b\u6709\u53d1\u751f\u4e86\u5f02\u5e38\uff1a\uff1a" + e.getLocalizedMessage()));
        }
    }

    public SaveMissionChangedLog getSaveMissionChangedLog() {
        return this.saveMissionChangedLog;
    }

    public void setSaveMissionChangedLog(SaveMissionChangedLog saveMissionChangedLog) {
        this.saveMissionChangedLog = saveMissionChangedLog;
    }

    public IConfigLogic getConfigLogic() {
        return this.configLogic;
    }

    public void setConfigLogic(IConfigLogic configLogic) {
        this.configLogic = configLogic;
    }
}

