/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.impl.DFTFrame;
import com.trs.infra.discover.impl.FilterType;
import com.trs.infra.discover.impl.Node;
import com.trs.infra.discover.impl.NodeDirectory;
import com.trs.infra.discover.impl.NodeResource;
import com.trs.infra.discover.impl.NodeType;
import com.trs.infra.discover.impl.Utils;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;

public class Container {
    URL m_oLocation;
    List m_oRootNode;

    protected static String[] splitPath(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        String[] rs = new String[st.countTokens()];
        int i = 0;
        while (i < rs.length && st.hasMoreTokens()) {
            rs[i] = st.nextToken();
            ++i;
        }
        return rs;
    }

    public Container(URL location) {
        this.m_oLocation = location;
        this.m_oRootNode = new ArrayList();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Container:Location=").append(this.m_oLocation);
        sb.append(",RootNodeList=").append(this.m_oRootNode);
        return sb.toString();
    }

    public void cleanup() {
        Iterator itr = this.m_oRootNode.iterator();
        while (itr.hasNext()) {
            Node c = (Node)itr.next();
            if (c == null) continue;
            c.cleanup();
        }
        this.m_oRootNode.clear();
        this.m_oRootNode = null;
    }

    public void tree(PrintWriter pw, String prefix) {
        List list = this.m_oRootNode;
        int limit = list.size() - 1;
        int i = 0;
        while (i <= limit) {
            String p = null;
            Node n = (Node)list.get(i);
            if (i == limit) {
                pw.print(prefix);
                pw.print("\u2514\u2500");
                p = String.valueOf(prefix) + "    ";
            } else {
                pw.print(prefix);
                pw.print("\u251c\u2500");
                p = String.valueOf(prefix) + "\u2502  ";
            }
            pw.println(n.getName());
            if (n.isDirectory()) {
                ((NodeDirectory)n).tree(pw, p);
            }
            ++i;
        }
    }

    public URL getLocation() {
        return this.m_oLocation;
    }

    protected void trimMemory() {
        Iterator itr = this.m_oRootNode.iterator();
        while (itr.hasNext()) {
            Node c = (Node)itr.next();
            if (c == null) continue;
            c.trimMemory();
        }
        Utils.trimArrayList(this.m_oRootNode);
    }

    protected void addRootNode(Node node) {
        this.m_oRootNode.add(node);
        node.setContainer(this);
    }

    protected NodeDirectory getRootDirectory(String name) {
        Iterator itr = this.m_oRootNode.iterator();
        while (itr.hasNext()) {
            Node node = (Node)itr.next();
            if (!node.getName().equals(name)) continue;
            return (NodeDirectory)node;
        }
        NodeDirectory nd = new NodeDirectory(name);
        this.addRootNode(nd);
        return nd;
    }

    protected void addDirectory(String path) {
        String[] names = Container.splitPath(path);
        int count = names.length;
        if (count <= 0) {
            return;
        }
        NodeDirectory parent = this.getRootDirectory(names[0]);
        int i = 1;
        while (i < count) {
            parent = parent.getDirectoryNode(names[i]);
            ++i;
        }
    }

    protected Node findNode(String[] path) {
        List list = this.m_oRootNode;
        int limit = path.length - 1;
        int i = 0;
        while (i <= limit) {
            Node node = null;
            String name = path[i];
            int j = 0;
            while (j < list.size()) {
                Node temp = (Node)list.get(j);
                if (name.endsWith(temp.getName())) {
                    node = temp;
                    break;
                }
                ++j;
            }
            if (node == null) break;
            if (i == limit) {
                return node;
            }
            if (!node.isDirectory() || (list = ((NodeDirectory)node).children()) == null) break;
            ++i;
        }
        return null;
    }

    private NodeResource findResource0(List list, String name) {
        int i = 0;
        while (i < list.size()) {
            Node node = (Node)list.get(i);
            if (node.isDirectory()) {
                List list0;
                NodeResource node0;
                if (node.hasChild() && (node0 = this.findResource0(list0 = ((NodeDirectory)node).children(), name)) != null) {
                    return node0;
                }
            } else if (name.equals(node.getName())) {
                return (NodeResource)node;
            }
            ++i;
        }
        return null;
    }

    protected NodeResource findResource(String name) {
        return this.findResource0(this.m_oRootNode, name);
    }

    protected Iterator findResources(final String name) {
        Iterator itr = new Iterator(){
            private DFTFrame m_oFrame;
            private Stack m_oStack;
            private NodeResource m_oFound;
            {
                this.m_oFrame = new DFTFrame(Container.this.m_oRootNode);
                this.m_oStack = new Stack();
                this.m_oFound = null;
            }

            /*
             * Unable to fully structure code
             */
            private void findNext() {
                if (this.m_oFound == null) ** GOTO lbl15
                return;
                {
                    if (name.equals((node = (Node)this.m_oFrame.list.get(this.m_oFrame.index++)).getName()) && node instanceof NodeResource) {
                        this.m_oFound = (NodeResource)node;
                        return;
                    }
                    if (node instanceof NodeDirectory && (dir = (NodeDirectory)node).hasChild()) {
                        this.m_oStack.push(this.m_oFrame);
                        this.m_oFrame = new DFTFrame(dir.children());
                    }
                    do {
                        if (this.m_oFrame.index < this.m_oFrame.list.size()) continue block0;
                        this.m_oFrame = null;
                        if (this.m_oStack.size() <= 0) continue;
                        this.m_oFrame = (DFTFrame)this.m_oStack.pop();
lbl15:
                        // 3 sources

                    } while (this.m_oFrame != null);
                }
            }

            public boolean hasNext() {
                this.findNext();
                return this.m_oFound != null;
            }

            public Object next() {
                this.findNext();
                if (this.m_oFound != null) {
                    NodeResource node = this.m_oFound;
                    this.m_oFound = null;
                    return node;
                }
                return null;
            }

            public void remove() {
            }
        };
        return itr;
    }

    protected Iterator findTypes(final FilterType filter) {
        Iterator itr = new Iterator(){
            private DFTFrame m_oFrame;
            private Stack m_oStack;
            private NodeType m_oFound;
            {
                this.m_oFrame = new DFTFrame(Container.this.m_oRootNode);
                this.m_oStack = new Stack();
                this.m_oFound = null;
            }

            /*
             * Unable to fully structure code
             */
            private void findNext() {
                if (this.m_oFound == null) ** GOTO lbl17
                return;
                {
                    if ((node = (Node)this.m_oFrame.list.get(this.m_oFrame.index++)) instanceof NodeType) {
                        temp = (NodeType)node;
                        if (filter == null || filter.accept(temp)) {
                            this.m_oFound = (NodeType)node;
                            return;
                        }
                    }
                    if (node instanceof NodeDirectory && (dir = (NodeDirectory)node).hasChild()) {
                        this.m_oStack.push(this.m_oFrame);
                        this.m_oFrame = new DFTFrame(dir.children());
                    }
                    do {
                        if (this.m_oFrame.index < this.m_oFrame.list.size()) continue block0;
                        this.m_oFrame = null;
                        if (this.m_oStack.size() <= 0) continue;
                        this.m_oFrame = (DFTFrame)this.m_oStack.pop();
lbl17:
                        // 3 sources

                    } while (this.m_oFrame != null);
                }
            }

            public boolean hasNext() {
                this.findNext();
                return this.m_oFound != null;
            }

            public Object next() {
                this.findNext();
                if (this.m_oFound != null) {
                    NodeType nodetype = this.m_oFound;
                    this.m_oFound = null;
                    return nodetype;
                }
                return null;
            }

            public void remove() {
            }
        };
        return itr;
    }
}

