/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.xml.node;

import com.trs.dev4.jdk16.xml.node.ContainerNode;

public class CommonNode
extends ContainerNode {
    private String nodeValue;
    private boolean CDATANeeded = false;

    public CommonNode(String nodeName) {
        super(nodeName);
    }

    @Override
    protected boolean hasNodeValue() {
        return super.hasNodeValue() || this.nodeValue != null && this.nodeValue.length() > 0;
    }

    @Override
    protected String getNodeValue() {
        if (super.hasNodeValue()) {
            return super.getNodeValue();
        }
        if (!this.CDATANeeded) {
            return this.nodeValue;
        }
        StringBuffer sb = new StringBuffer(this.nodeValue.length() + 20);
        sb.append("<![CDATA[").append(this.nodeValue).append("]]>");
        return sb.toString();
    }

    public boolean isCDATANeeded() {
        return this.CDATANeeded;
    }

    public void setCDATANeeded(boolean needed) {
        this.CDATANeeded = needed;
    }

    public void setNodeValue(String nodeValue) {
        this.nodeValue = nodeValue;
        this.setCDATANeeded(true);
    }

    public void setNodeValue(int nodeValue) {
        this.nodeValue = String.valueOf(nodeValue);
        this.setCDATANeeded(false);
    }
}

