/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.ArrayUtil;
import com.trs.dev4.jdk16.utils.AssertUtil;
import com.trs.dev4.jdk16.utils.CloseUtil;
import com.trs.dev4.jdk16.utils.CollectionUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;

public class DigestUtil {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    public static String md5Hex(String sData) {
        byte[] bytes;
        AssertUtil.notNull(sData, "sData is null.");
        try {
            bytes = sData.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new WrappedException(e);
        }
        return StringHelper.toString(DigestUtil.md5Checksum(bytes));
    }

    public static String md5Hex(File file) {
        FileInputStream is;
        AssertUtil.notNull(file, "file is null.");
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new WrappedException(e);
        }
        return StringHelper.toString(DigestUtil.md5Checksum(is));
    }

    static byte[] md5Checksum(byte[] data) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new WrappedException(e);
        }
        md5.update(data);
        return md5.digest();
    }

    static byte[] md5Checksum(InputStream is) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new WrappedException(e);
        }
        DigestInputStream dis = null;
        try {
            try {
                dis = new DigestInputStream(is, md5);
                byte[] buffer = new byte[1024];
                int read = dis.read(buffer, 0, 1024);
                while (read > -1) {
                    read = dis.read(buffer, 0, 1024);
                }
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.closeInputStream(dis);
            throw throwable;
        }
        CloseUtil.closeInputStream(dis);
        return md5.digest();
    }

    /*
     * WARNING - void declaration
     */
    static void listSecuProvidersAndServiceTypes() {
        Object[] providers = Security.getProviders();
        System.out.println("all providers: " + ArrayUtil.toString(providers));
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < providers.length) {
            Set<Object> keys = ((Provider)providers[i]).keySet();
            for (String string : keys) {
                void var5_5;
                String string2 = string.split(" ")[0];
                if (string2.startsWith("Alg.Alias.")) {
                    String string3 = string2.substring(10);
                }
                int ix = var5_5.indexOf(46);
                result.add(var5_5.substring(0, ix));
            }
            ++i;
        }
        System.out.println(CollectionUtil.toString(result));
    }
}

