/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao;

import com.trs.dev4.jdk16.utils.ArrayUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;

public class HQLBuilder {
    private static final String HQL_SEPARATOR_COMMA = ",";
    private static final String HQL_LEFTBRANKET = "(";
    private static final String HQL_RIGHTBRANKET = ")";
    private static final String HQL_DESC = "DESC";
    private static final String HQL_ASC = "ASC";
    private static final String HQL_OR = "OR";
    private static final String HQL_AND = "AND";
    private static final String HQL_SET = "SET";
    private static final String HQL_FROM = "FROM";
    private static final String HQL_ORDERBY = "ORDER BY";
    private static final String HQL_WHERE = "WHERE";
    private static final String HQL_SEPARATOR = " ";
    private static final String PREFIX_UPDATE = "UPDATE";
    private static final String PREFIX_DELETE = "DELETE";
    private List<Condition> parameterValues = new ArrayList<Condition>();
    private List<Expression> whereExpressions = new ArrayList<Expression>();
    private Expression currentExpression;
    private Class<? extends Object> objectClass;
    private String prefix;
    private List<OrderBy> orderBys = new ArrayList<OrderBy>();
    private List<Condition> assignExpressions = new ArrayList<Condition>();

    protected HQLBuilder(String prefix, Class<? extends Object> objectClass) {
        this.prefix = prefix;
        this.objectClass = objectClass;
    }

    public static HQLBuilder DELETE(Class<? extends Object> objectClass) {
        HQLBuilder builder = new HQLBuilder(PREFIX_DELETE, objectClass);
        return builder;
    }

    public static HQLBuilder UPDATE(Class<? extends Object> objectClass) {
        HQLBuilder builder = new HQLBuilder(PREFIX_UPDATE, objectClass);
        return builder;
    }

    @Deprecated
    public HQLBuilder addCondition(String field, String operator, Object value) {
        if ("in".equals(operator)) {
            if (!value.getClass().isArray()) {
                value = new Object[]{value};
            }
            return this.addInCondition(field, value);
        }
        if (this.currentExpression instanceof Condition) {
            throw new IllegalArgumentException("Can't add Condition.Add relationship(addAND or addOR) first.");
        }
        if (this.isUpdateHQL() && this.assignExpressions.size() == 0) {
            throw new IllegalArgumentException("Can't add Condition.Add assignExpression(setNewValue) first.");
        }
        this.currentExpression = new Condition(field, operator, value);
        this.whereExpressions.add(this.currentExpression);
        return this;
    }

    public HQLBuilder addInCondition(String field, Object[] value) {
        if (value == null || value.length == 0) {
            return this;
        }
        if (this.currentExpression instanceof Condition) {
            throw new IllegalArgumentException("Can't add Condition.Add relationship(addAND or addOR) first.");
        }
        if (this.isUpdateHQL() && this.assignExpressions.size() == 0) {
            throw new IllegalArgumentException("Can't add Condition.Add assignExpression(setNewValue) first.");
        }
        this.currentExpression = new InCondition(field, value);
        this.whereExpressions.add(this.currentExpression);
        return this;
    }

    public HQLBuilder addInCondition(String field, int[] value) {
        return this.addInCondition(field, (Object[])ArrayUtil.toIntegerArray(value));
    }

    public HQLBuilder addGreaterThan(String field, Object value) {
        return this.addCondition(field, ">", value);
    }

    public HQLBuilder addGreaterThanEquals(String field, Object value) {
        return this.addCondition(field, ">=", value);
    }

    public HQLBuilder addLesserThan(String field, Object value) {
        return this.addCondition(field, "<", value);
    }

    public HQLBuilder addLesserThanEquals(String field, Object value) {
        return this.addCondition(field, "<=", value);
    }

    public boolean isUpdateHQL() {
        return this.prefix.equalsIgnoreCase(PREFIX_UPDATE);
    }

    public HQLBuilder addEqCondition(String field, Object value) {
        return this.addCondition(field, "=", value);
    }

    @Deprecated
    public HQLBuilder addExpression(String field, String expression) {
        return this.addCondition(field, "=", expression);
    }

    public HQLBuilder addAND() {
        return this.addRelation(HQL_AND);
    }

    public HQLBuilder setNewValue(String field, Object value) {
        if (!this.isUpdateHQL()) {
            throw new IllegalArgumentException("Can't assign new Value,only update HQL supported.");
        }
        this.assignExpressions.add(new ExpressionCondition(field, "=", value));
        return this;
    }

    private HQLBuilder addRelation(String relation) {
        if (this.currentExpression instanceof Relation) {
            throw new IllegalArgumentException("");
        }
        this.currentExpression = new Relation(relation);
        this.whereExpressions.add(this.currentExpression);
        return this;
    }

    public HQLBuilder addOR() {
        return this.addRelation(HQL_OR);
    }

    public HQLBuilder addAscOrder(String field) {
        return this.addOrderBy(field, HQL_ASC);
    }

    public HQLBuilder addDescOrder(String field) {
        return this.addOrderBy(field, HQL_DESC);
    }

    public String getPreparedHQL() {
        this.parameterValues.clear();
        if (this.isUpdateHQL()) {
            return this.getUpdatePreparedHQL();
        }
        return this.getDeletePreparedHQL();
    }

    private String getDeletePreparedHQL() {
        StringBuffer preparedHQL = new StringBuffer();
        preparedHQL.append(this.prefix).append(HQL_SEPARATOR).append(HQL_FROM).append(HQL_SEPARATOR);
        preparedHQL.append(this.objectClass.getSimpleName()).append(HQL_SEPARATOR).append(this.buildWhereHQL());
        return preparedHQL.toString();
    }

    private String buildWhereHQL() {
        StringBuilder searchHQL = new StringBuilder();
        if (this.whereExpressions.size() > 0) {
            searchHQL.append(HQL_WHERE).append(HQL_SEPARATOR).append(this.buildWhereExpression()).append(HQL_SEPARATOR);
        }
        if (this.orderBys.size() > 0) {
            searchHQL.append(HQL_ORDERBY).append(HQL_SEPARATOR).append(this.buildOrderBy());
        }
        return searchHQL.toString().trim();
    }

    private String buildOrderBy() {
        StringBuilder orderBy = new StringBuilder();
        if (this.orderBys.size() > 0) {
            orderBy.append(this.orderBys.get(0).toHQL());
            int i = 0;
            while (i < this.orderBys.size()) {
                orderBy.append(HQL_SEPARATOR_COMMA).append(this.orderBys.get(i).toHQL());
                ++i;
            }
        }
        return orderBy.toString();
    }

    private String buildWhereExpression() {
        StringBuffer where = new StringBuffer();
        if (this.whereExpressions.size() > 0) {
            where.append(this.whereExpressions.get(0).toHQL());
            this.parameterValues.add((Condition)this.whereExpressions.get(0));
            int i = 1;
            while (i < this.whereExpressions.size()) {
                where.append(HQL_SEPARATOR).append(this.whereExpressions.get(i).toHQL());
                if (this.whereExpressions.get(i) instanceof Condition) {
                    this.parameterValues.add((Condition)this.whereExpressions.get(i));
                }
                ++i;
            }
        }
        return where.toString();
    }

    private String getUpdatePreparedHQL() {
        StringBuilder preparedHQL = new StringBuilder();
        preparedHQL.append(this.prefix).append(HQL_SEPARATOR).append(this.objectClass.getSimpleName()).append(HQL_SEPARATOR);
        preparedHQL.append(this.buildSetClause());
        preparedHQL.append(this.buildWhereHQL());
        return preparedHQL.toString().trim();
    }

    private Object buildSetClause() {
        StringBuilder setClause = new StringBuilder();
        if (this.assignExpressions.size() > 0) {
            setClause.append(HQL_SET).append(HQL_SEPARATOR);
            this.buildSetClause(setClause, this.assignExpressions.get(0));
            int i = 1;
            while (i < this.assignExpressions.size()) {
                setClause.append(HQL_SEPARATOR_COMMA);
                this.buildSetClause(setClause, this.assignExpressions.get(i));
                ++i;
            }
        }
        return setClause.toString();
    }

    private void buildSetClause(StringBuilder setClause, Condition assignmentExpression) {
        this.parameterValues.add(assignmentExpression);
        setClause.append(assignmentExpression.toHQL());
        setClause.append(HQL_SEPARATOR);
    }

    public List<Condition> getParameterValues() {
        return this.parameterValues;
    }

    private HQLBuilder addOrderBy(String field, String order) {
        this.orderBys.add(new OrderBy(field, order));
        return this;
    }

    public class Condition
    implements Expression {
        protected static final String PARAMETER_PREFIX = ":";
        protected String field;
        protected String operator;
        protected Object value;

        public Condition(String field, String operator, Object value) {
            this.field = field;
            this.operator = operator;
            this.value = value;
        }

        @Override
        public String toHQL() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.field).append(HQLBuilder.HQL_SEPARATOR).append(this.operator).append(HQLBuilder.HQL_SEPARATOR).append(PARAMETER_PREFIX).append(this.getParameterName());
            return sb.toString();
        }

        public Object getValue() {
            return this.value;
        }

        public String getParameterName() {
            return this.field;
        }

        public boolean isValueType() {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(HQLBuilder.HQL_LEFTBRANKET).append(this.field).append(this.operator).append(this.value).append(", parameterName: " + this.getParameterName() + HQLBuilder.HQL_RIGHTBRANKET);
            sb.append(super.toString());
            return sb.toString();
        }

        public String getField() {
            return this.field;
        }

        public String getOperator() {
            return this.operator;
        }
    }

    static interface Expression {
        public String toHQL();
    }

    class ExpressionCondition
    extends Condition {
        private static final String PARAMETER_ASSGIN = "new";

        public ExpressionCondition(String field, String operator, Object value) {
            super(field, operator, value);
        }

        @Override
        public boolean isValueType() {
            return false;
        }

        @Override
        public String getParameterName() {
            StringBuilder sb = new StringBuilder();
            sb.append(PARAMETER_ASSGIN).append(this.getField());
            return sb.toString();
        }
    }

    public class InCondition
    extends Condition {
        public InCondition(String field, Object[] value) {
            super(field, "in", value);
        }

        @Override
        public String toHQL() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.field).append(HQLBuilder.HQL_SEPARATOR).append(this.operator).append(HQLBuilder.HQL_SEPARATOR).append(HQLBuilder.HQL_LEFTBRANKET).append(":").append(this.getParameterName()).append(HQLBuilder.HQL_RIGHTBRANKET);
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(HQLBuilder.HQL_LEFTBRANKET).append(this.field).append(this.operator).append(StringHelper.join((Object[])this.value)).append(", parameterName: " + this.getParameterName() + HQLBuilder.HQL_RIGHTBRANKET);
            sb.append(super.toString());
            return sb.toString();
        }
    }

    class OrderBy {
        private String field;
        private String order;

        public OrderBy(String field, String order) {
            this.field = field;
            this.order = order;
        }

        public String toHQL() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.field).append(HQLBuilder.HQL_SEPARATOR).append(this.order);
            return sb.toString();
        }
    }

    class Relation
    implements Expression {
        private String name;

        public Relation(String name) {
            this.name = name;
        }

        @Override
        public String toHQL() {
            return this.name;
        }
    }
}

