/*
 * Decompiled with CFR 0.152.
 */
package com.trs.client;

import com.trs.client.TRSConnection;
import com.trs.client.TRSException;
import com.trs.client.TRSJNIV61;
import java.io.File;

public final class TRSTransFile {
    private TRSConnection m_con;

    public TRSTransFile(TRSConnection con, String sFileName) throws TRSException {
        this.m_con = con;
        if (con == null || con.getHandle() == 0L) {
            throw TRSException.New(500002, "");
        }
        int _iRet = TRSJNIV61.TRS_OpenTransFile(this.m_con.getHandle(), sFileName, false);
        if (_iRet <= 0) {
            this.m_con.newTRSException();
        }
    }

    public int WriteRecord(int iSecurityCode, String sUserGroup, String sPassword) throws TRSException {
        int _iRet = TRSJNIV61.TRS_WriteTransRecord(this.m_con.getHandle(), iSecurityCode, sUserGroup, sPassword);
        if (_iRet < 0) {
            this.m_con.newTRSException();
        }
        return _iRet;
    }

    public int WriteColumn(String strColName, String strValue, String strFormat, String strStorage) throws TRSException {
        int _iRet = TRSJNIV61.TRS_WriteTransColumn(this.m_con.getHandle(), strColName, strValue, null, 0, strFormat, strStorage, false);
        if (_iRet < 0) {
            this.m_con.newTRSException();
        }
        return _iRet;
    }

    public int WriteColumn(String strColName, byte[] bValue, int iLen, String strFormat, String strStorage) throws TRSException {
        int _iRet = TRSJNIV61.TRS_WriteTransColumn(this.m_con.getHandle(), strColName, null, bValue, iLen, strFormat, strStorage, false);
        if (_iRet < 0) {
            this.m_con.newTRSException();
        }
        return _iRet;
    }

    public int WriteColumn(String strColName, File fFile, String strFormat, String strStorage) throws TRSException {
        if (fFile == null) {
            throw TRSException.New(500016, "");
        }
        if (!fFile.isFile() || !fFile.canRead()) {
            throw TRSException.New(500016, fFile.getAbsolutePath());
        }
        int _iRet = TRSJNIV61.TRS_WriteTransColumn(this.m_con.getHandle(), strColName, fFile.getAbsolutePath(), null, 0, strFormat, strStorage, true);
        if (_iRet < 0) {
            this.m_con.newTRSException();
        }
        return _iRet;
    }

    public void flush() throws TRSException {
        int _iRet = TRSJNIV61.TRS_FlushTransFile(this.m_con.getHandle());
        if (_iRet < 0) {
            this.m_con.newTRSException();
        }
    }

    public void close() {
        try {
            TRSJNIV61.TRS_CloseTransFile(this.m_con.getHandle());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

