/*
 * Decompiled with CFR 0.152.
 */
package com.eprobiti.trs;

import com.eprobiti.trs.RecordReport;
import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSDataBaseColumn;
import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSIndex;
import com.eprobiti.trs.TRSJNIV61;
import com.eprobiti.trs.TRSObject;
import com.eprobiti.trs.TRSUtils;
import java.util.Vector;

public class TRSDataBase
extends TRSObject {
    private String m_sDelColumns = null;
    private Vector m_vAddColumns = new Vector();
    private Vector m_vModColumns = new Vector();
    private static final String[] m_saBasePropertyNames = new String[]{"ID", "NAME", "COMMENT", "CREATEDATE", "UPDATEDATE", "OWNER", "TYPE", "COLUMNNUM", "RECORDNUM", "PUBLIC", "ALIAS", "FIRSTTEXTCOL", "DATAPATH", "DATAHOST", "LANGUAGE", "LOCKMODE", "LOCKOWNER", "SEGMENTDIC", "SEGMENTDICEX", "STOPDIC", "STOPDICEX", "SPARSEDIC", "INDEXSTEM", "CASESENSITIVE", "IGNOREDIGIT", "MIXINDEX", "NOTPACKINDEX", "SPLIT", "BACKUPINC", "MIRRORSYNC", "BANSTOPDIC"};

    TRSDataBase(String strPropertyValue, TRSConnection conn) throws TRSException {
        super(conn, 18, m_saBasePropertyNames, strPropertyValue);
        if (conn == null) {
            throw TRSException.New(500002, "");
        }
        if (strPropertyValue == null) {
            throw TRSException.New(500011, "");
        }
    }

    public TRSDataBase(TRSConnection conn, String strName) throws TRSException {
        super(conn, 18, strName, m_saBasePropertyNames);
        if (conn == null) {
            throw TRSException.New(500002, "");
        }
        if (strName == null) {
            throw TRSException.New(500014, "");
        }
    }

    public TRSIndex[] getIndexes() throws TRSException {
        String[] _saIndexProperties = TRSJNIV61.TRS_GetObjectList(super.getHandle(), 23, 0, String.valueOf(super.getOwner()) + "." + super.getName(), null, 0);
        if (_saIndexProperties == null) {
            throw super.newTRSException();
        }
        int _iIndexCount = _saIndexProperties.length;
        TRSIndex[] _oaIndexs = new TRSIndex[_iIndexCount];
        int i = 0;
        while (i < _iIndexCount) {
            String[] _saPropertySplits = TRSUtils.split(_saIndexProperties[i], "\u0001");
            _oaIndexs[i] = new TRSIndex();
            _oaIndexs[i].iColType = TRSUtils.getIntPropertValue(_saPropertySplits, "COLTYPE");
            _oaIndexs[i].iDivRecordID = TRSUtils.getIntPropertValue(_saPropertySplits, "DIVRECORDID");
            _oaIndexs[i].iMaxRecordID = TRSUtils.getIntPropertValue(_saPropertySplits, "MAXRECORDID");
            _oaIndexs[i].strColumn = TRSUtils.getStrPropertValue(_saPropertySplits, "COLUMN");
            ++i;
        }
        return _oaIndexs;
    }

    public boolean addColumn(TRSDataBaseColumn[] oaAddCols) {
        if (oaAddCols == null) {
            return false;
        }
        int i = 0;
        while (i < oaAddCols.length) {
            this.m_vAddColumns.add(oaAddCols[i]);
            ++i;
        }
        return true;
    }

    public boolean alterColumn(TRSDataBaseColumn[] oaAlterCols) {
        if (oaAlterCols == null) {
            return false;
        }
        int i = 0;
        while (i < oaAlterCols.length) {
            this.m_vModColumns.add(oaAlterCols[i]);
            ++i;
        }
        return true;
    }

    public int AutomateView() throws TRSException {
        return this.automateView() ? 1 : 0;
    }

    public boolean automateView() throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_AutomateViewEx(super.getHandle(), super.getName(), super.getOwner(), "");
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean automateView(String strCondition) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_AutomateViewEx(super.getHandle(), super.getName(), super.getOwner(), strCondition);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean backup(String strDevice) throws TRSException {
        return super.getConnection().backupDatabases(this.getFullName(), strDevice) != 0;
    }

    public void cancelAlter() {
        super.cancelAlter();
        this.m_vAddColumns.removeAllElements();
        this.m_vModColumns.removeAllElements();
        this.m_sDelColumns = null;
    }

    public RecordReport copyRecords(String strSrcName, String strSrcOwner, String strColumns, String strWhereExpr, String strSortMethod, boolean bSyncIndex) throws TRSException {
        return super.getConnection().copyRecords(super.getName(), super.getOwner(), strSrcName, strSrcOwner, strColumns, strWhereExpr, strSortMethod, bSyncIndex);
    }

    public boolean create() throws TRSException {
        int _ret;
        String[] _saColumnProperties = null;
        String _strBaseProperties = super.getUpdateProperties();
        if (this.m_vAddColumns.size() != 0) {
            _saColumnProperties = new String[this.m_vAddColumns.size()];
            int i = 0;
            while (i < this.m_vAddColumns.size()) {
                _saColumnProperties[i] = ((TRSObject)this.m_vAddColumns.elementAt(i)).getUpdateProperties();
                ++i;
            }
        }
        if ((_ret = TRSJNIV61.TRS_Admin_CreateDataBase(super.getHandle(), _strBaseProperties, _saColumnProperties)) < 0) {
            throw super.newTRSException();
        }
        super.updateProperties();
        return true;
    }

    public boolean create(String strSourceCols) throws TRSException {
        String _strBaseProperties = super.getUpdateProperties();
        int _ret = TRSJNIV61.TRS_Admin_CopyDataBase(super.getHandle(), _strBaseProperties, strSourceCols);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        super.updateProperties();
        return true;
    }

    public boolean create(String strSourceCols, String strProperty) throws TRSException {
        String _strBaseProperties = "NAME=" + super.getName() + "\u0001";
        _strBaseProperties = String.valueOf(_strBaseProperties) + "OWNER=" + super.getOwner() + "\u0001";
        _strBaseProperties = String.valueOf(_strBaseProperties) + strProperty;
        int _ret = TRSJNIV61.TRS_Admin_CopyDataBase(super.getHandle(), _strBaseProperties, strSourceCols);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        super.updateProperties();
        return true;
    }

    public boolean createIndex(String strColumns, int iStopRecord) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_CreateIndex(super.getHandle(), super.getName(), super.getOwner(), strColumns, iStopRecord);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean deleteColumn(String strDelCols) {
        this.m_sDelColumns = strDelCols;
        return true;
    }

    public boolean deleteIndex(String strColumns, int iStartRecord) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_DeleteIndex(super.getHandle(), super.getName(), super.getOwner(), strColumns, iStartRecord);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public int deleteRecords(String strWhere, boolean bFastEnable) throws TRSException {
        return super.getConnection().executeDelete(super.getName(), super.getOwner(), strWhere, bFastEnable);
    }

    public boolean extendAttribute(int iAddOpt, int iDelOpt) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_ExtendAttribute(super.getHandle(), super.getName(), super.getOwner(), iAddOpt, iDelOpt);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public TRSDataBaseColumn[] getColumns() throws TRSException {
        return this.getColumns("*");
    }

    public TRSDataBaseColumn[] getColumns(String strColNames) throws TRSException {
        String _strBaseName = super.getFullName();
        String[] _saColProperties = TRSJNIV61.TRS_GetObjectList(super.getHandle(), 19, 0, _strBaseName, strColNames, 0);
        if (_saColProperties == null) {
            throw super.newTRSException();
        }
        int _iColCount = _saColProperties.length;
        TRSDataBaseColumn[] _oaBaseCols = new TRSDataBaseColumn[_iColCount];
        int i = 0;
        while (i < _iColCount) {
            _oaBaseCols[i] = new TRSDataBaseColumn(_saColProperties[i]);
            ++i;
        }
        return _oaBaseCols;
    }

    public String getDatabaseProperty() throws TRSException {
        return super.getProperties();
    }

    public int getUserRightInfo(String strUserName) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GetRightInfo(super.getHandle(), strUserName, super.getName(), super.getOwner(), null);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return _ret;
    }

    public int getUserRightInfo(String strUserName, String strColumn) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GetRightInfo(super.getHandle(), strUserName, super.getName(), super.getOwner(), strColumn);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return _ret;
    }

    public void grantUserRight(String strUserNames, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GrantRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), null);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public void grantUserRight(String strUserNames, String strColumns, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_GrantRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), strColumns);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public int insertRecord(String strValues) throws TRSException {
        return super.getConnection().executeInsert(super.getName(), super.getOwner(), strValues);
    }

    public RecordReport loadRecords(String strSrcFileName, String strCtrlFileName, boolean bBatchMode) throws TRSException {
        return super.getConnection().loadRecords(super.getName(), super.getOwner(), strSrcFileName, strCtrlFileName, bBatchMode);
    }

    public boolean lock(int iLockMode) throws TRSException {
        String _strBaseName = super.getFullName();
        int _ret = TRSJNIV61.TRS_Admin_LockDatabase(super.getHandle(), _strBaseName, iLockMode);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean optimize(String strColumns, String strDevice) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_OptimizeDatabase(super.getHandle(), super.getName(), super.getOwner(), strColumns, strDevice);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public boolean renameColumn(String strOldName, String strNewName) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_RenameObject(super.getHandle(), 19, super.getName(), super.getOwner(), strOldName, strNewName);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }

    public void revokeUserRight(String strUserNames, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_RevokeRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), null);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public void revokeUserRight(String strUserNames, String strColumns, int iRightMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_RevokeRight(super.getHandle(), iRightMask, strUserNames, super.getName(), super.getOwner(), strColumns);
        if (_ret < 0) {
            throw super.newTRSException();
        }
    }

    public void unLock() throws TRSException {
        this.lock(80);
    }

    public boolean updateAlter() throws TRSException {
        int _ret;
        int i;
        String[] _saAddColumns = null;
        String[] _saAlterColumns = null;
        String _strBaseProperties = super.getUpdateProperties();
        if (this.m_vAddColumns.size() != 0) {
            _saAddColumns = new String[this.m_vAddColumns.size()];
            i = 0;
            while (i < this.m_vAddColumns.size()) {
                _saAddColumns[i] = ((TRSObject)this.m_vAddColumns.elementAt(i)).getUpdateProperties();
                ++i;
            }
        }
        if (this.m_vModColumns.size() != 0) {
            _saAlterColumns = new String[this.m_vModColumns.size()];
            i = 0;
            while (i < this.m_vModColumns.size()) {
                _saAlterColumns[i] = ((TRSObject)this.m_vModColumns.elementAt(i)).getUpdateProperties();
                ++i;
            }
        }
        if ((_ret = TRSJNIV61.TRS_Admin_AlterDataBase(super.getHandle(), _strBaseProperties, _saAddColumns, _saAlterColumns, this.m_sDelColumns)) < 0) {
            throw super.newTRSException();
        }
        super.updateProperties();
        return true;
    }

    public int updateRecords(String strValues, String strWhere) throws TRSException {
        return super.getConnection().executeUpdate(super.getName(), super.getOwner(), strValues, strWhere);
    }

    public boolean validateIndex(String strColumns) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_ValidateIndex(super.getHandle(), super.getName(), super.getOwner(), strColumns);
        if (_ret < 0) {
            throw super.newTRSException();
        }
        return true;
    }
}

