/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.gateway.logic.impl;

import com.trs.cis4.bean.PageInfo;
import com.trs.cis4.bean.SysUser;
import com.trs.cis4.gateway.dao.ISysUserDAO;
import com.trs.cis4.gateway.logic.IBaseSysUserLogic;
import com.trs.cis4.util.ExceptionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseSysUserLogicImpl
implements IBaseSysUserLogic {
    private Logger log = Logger.getLogger(this.getClass());
    private ISysUserDAO sysUserDAO;

    @Override
    public void delete(String userid) throws ExceptionUtil {
        this.sysUserDAO.delete(userid);
    }

    @Override
    public void saveOrUpdate(SysUser sysUser) throws ExceptionUtil {
        this.sysUserDAO.saveOrUpdate(sysUser);
    }

    @Override
    public Vector searchUserHQLData(PageInfo pageInfo) throws ExceptionUtil {
        int curPageCode = pageInfo.getCurPageCode();
        int numPerPage = pageInfo.getPerPageCount();
        List<SysUser> list = this.sysUserDAO.getAlls();
        int count = list.size();
        ArrayList<SysUser> ret = new ArrayList<SysUser>();
        if (count > 0) {
            int istart = (curPageCode - 1) * numPerPage;
            if (istart >= count) {
                int ppp = count / numPerPage;
                this.log.info((Object)("\u67e5\u8be2\u6700\u540e\u4e00\u9875\u6570\u636e\u4e3a\u7a7a\uff0c\u81ea\u52a8\u5f80\u524d\u7ffb" + ppp + "\u9875\uff01"));
                if (ppp == 0) {
                    ppp = 1;
                }
                istart = (ppp - 1) * numPerPage;
            }
            int iend = istart + numPerPage;
            int i = 0;
            while (i < count) {
                if (i >= istart && i < iend) {
                    ret.add(list.get(i));
                }
                ++i;
            }
        }
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.add(new Integer(count));
        vector.add(ret);
        return vector;
    }

    @Override
    public List<SysUser> getAllSysUsers() throws ExceptionUtil {
        return this.getSysUserDAO().getAlls();
    }

    @Override
    public SysUser getSysUser(String userid) throws ExceptionUtil {
        return this.getSysUserDAO().get(userid);
    }

    public ISysUserDAO getSysUserDAO() {
        return this.sysUserDAO;
    }

    public void setSysUserDAO(ISysUserDAO sysUserDAO) {
        this.sysUserDAO = sysUserDAO;
    }
}

