/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MdaManager;
import com.sybase.jdbc2.jdbc.Protocol;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.jdbc.SybUrlProvider;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SybConnection
implements com.sybase.jdbcx.SybConnection {
    static final int TRANSACTION_NONE = 0;
    static final int TRANSACTION_READ_UNCOMMITTED = 1;
    static final int TRANSACTION_READ_COMMITTED = 2;
    static final int TRANSACTION_REPEATABLE_READ = 4;
    static final int TRANSACTION_SERIALIZABLE = 8;
    private MdaManager _mda = null;
    protected SybDatabaseMetaData _sybDBMD = null;
    private SQLWarning _warning = null;
    protected Protocol _protocol;
    protected ProtocolContext _pc;
    protected SybProperty _props;
    protected boolean _dynamicPrepare;
    protected String _dbName;
    protected String _url = null;
    private int _loginTimeout;
    private int _state = 0;
    private int _dynStmtNum = 100;
    private Hashtable _cursors;
    private Vector _hostPortList = null;
    private Vector _secondaryHostPortList = null;
    private int _haLoginStatus = 0;
    private int _haState = -1;
    private boolean _wasConnected = false;
    private String _currentHostPort;
    private boolean _inClose = false;

    public SybConnection(SybUrlProvider sybUrlProvider, String string) throws SQLException {
        this(sybUrlProvider, string, DriverManager.getLoginTimeout() * 1000);
    }

    protected SybConnection(SybUrlProvider sybUrlProvider, String string, int n) throws SQLException {
        this._url = string;
        this._protocol = sybUrlProvider.getProtocol();
        this._props = sybUrlProvider.getSybProperty();
        this._hostPortList = sybUrlProvider.getHostPortList();
        this._dbName = sybUrlProvider.getDatabaseName();
        this._dynamicPrepare = this._props.getBoolean(25);
        this._loginTimeout = n * 1000;
        this._haState = -1;
        if (this._props.getBoolean(34)) {
            this._secondaryHostPortList = sybUrlProvider.getSecondaryHostPortList();
            if (this._secondaryHostPortList == null || this._secondaryHostPortList.size() == 0) {
                ErrorMessage.raiseError("JZ0F1");
            }
            this.setHALoginStatus(1);
            this.handleHAFailover();
        } else {
            this.regularConnect();
        }
    }

    protected void addCursorResultSet(String string, ResultSet resultSet) {
        if (this._cursors == null) {
            this._cursors = new Hashtable();
        }
        this._cursors.put(string, resultSet);
    }

    public void cancel() throws SQLException {
        this._protocol.cancel(this._pc, true);
    }

    public void chainWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = SybConnection.convertToWarnings(sQLException);
        if (this._warning == null) {
            this._warning = sQLWarning;
        } else {
            this._warning.setNextWarning(sQLWarning);
        }
    }

    protected void checkConnection() throws SQLException {
        if (this._state == 4) {
            if (this._props.getBoolean(34) && !this._inClose && this.getHAState() != 1 && this.getHAState() != 6) {
                this._state = 0;
                this.handleHAFailover();
            } else {
                ErrorMessage.raiseError("JZ0C0");
            }
        }
    }

    private void checkDBMD() throws SQLException {
        this.checkMDA(null);
        if (this._sybDBMD == null) {
            this._sybDBMD = new SybDatabaseMetaData(this);
        }
    }

    private void checkMDA(ProtocolContext protocolContext) throws SQLException {
        block6: {
            if (this._mda != null) break block6;
            try {
                if (protocolContext == null) {
                    SybConnection sybConnection = this;
                    synchronized (sybConnection) {
                        this._mda = new MdaManager(this, this._pc);
                        break block6;
                    }
                }
                this._mda = new MdaManager(this, protocolContext);
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkConnection();
        this._warning = null;
    }

    public void close() throws SQLException {
        this._inClose = true;
        this.checkConnection();
        if (this._cursors != null) {
            Enumeration enumeration = this._cursors.keys();
            try {
                while (true) {
                    String string = (String)enumeration.nextElement();
                    this._cursors.remove(string);
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        this.markDead(false);
        try {
            try {
                this._protocol.logout();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            Object var2_4 = null;
            this._pc.drop();
            this._inClose = false;
        }
        catch (Throwable throwable) {
            Object var2_5 = null;
            this._pc.drop();
            this._inClose = false;
            throw throwable;
        }
    }

    public void commit() throws SQLException {
        this.checkConnection();
        try {
            this._protocol.endTransaction(true);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public static SQLWarning convertToWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            SQLWarning sQLWarning2 = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
            } else {
                sQLWarning.setNextWarning(sQLWarning2);
            }
            sQLException2 = sQLException2.getNextException();
        }
        return sQLWarning;
    }

    public Capture createCapture() throws SQLException {
        return (Capture)this._protocol.getObjectOption(this._pc, 8);
    }

    public Statement createStatement() throws SQLException {
        this.checkConnection();
        SybStatement sybStatement = new SybStatement(this.initProtocol());
        return sybStatement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        SybStatement sybStatement = (SybStatement)this.createStatement();
        sybStatement.setResultSetParams(n, n2);
        return sybStatement;
    }

    public static SQLWarning getAllTheWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            if (sQLException2 instanceof SQLWarning) {
                if (sQLWarning == null) {
                    sQLWarning = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
                } else {
                    sQLWarning.setNextWarning(new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode()));
                }
            }
            sQLException2 = sQLException2.getNextException();
        }
        return sQLWarning;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkConnection();
        boolean bl = false;
        try {
            bl = this._protocol.getBoolOption(null, 1);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return bl;
    }

    public String getCatalog() throws SQLException {
        this.checkConnection();
        String string = null;
        try {
            string = this._protocol.getStringOption(null, 9, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return string;
    }

    protected ResultSet getCursorResultSet(String string) {
        if (this._cursors == null) {
            return null;
        }
        return (ResultSet)this._cursors.get(string);
    }

    public String getDefaultServerCharset() throws SQLException {
        this.checkConnection();
        String string = null;
        try {
            string = this._protocol.getStringOption(null, 6, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return string;
    }

    public Object getEndpoint() throws SQLException {
        return this._protocol.getObjectOption(this._pc, 7);
    }

    public int getHALoginStatus() {
        return this._haLoginStatus;
    }

    protected int getHAState() {
        return this._haState;
    }

    public MdaManager getMDA(ProtocolContext protocolContext) throws SQLException {
        this.checkMDA(protocolContext);
        return this._mda;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkConnection();
        this.checkDBMD();
        return this._sybDBMD;
    }

    public String getSessionID() throws SQLException {
        return this._protocol.getStringOption(null, 5, null);
    }

    public SybMessageHandler getSybMessageHandler() {
        return this._pc.getMessageHandler();
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkConnection();
        int n = -1;
        try {
            n = this._protocol.getIntOption(null, 2);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return n;
    }

    public Map getTypeMap() throws SQLException {
        Debug.notImplemented(this, "getTypeMap()");
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection();
        return this._warning;
    }

    public SQLWarning getWarningsNoCheckConnection() throws SQLException {
        return this._warning;
    }

    protected void handleHAFailover() throws SQLException {
        this.nextHAState();
        switch (this.getHAState()) {
            case 0: {
                this.setHALoginStatus(1);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 4: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 5: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 1: {
                this.setHALoginStatus(5);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
            case 6: {
                this.setHALoginStatus(7);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
        }
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        sQLWarning = !bl ? (SQLWarning)sQLException : SybConnection.getAllTheWarnings(sQLException);
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl && this._props != null) {
            throw sQLException;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void init() throws SQLException {
        block57: {
            var1_1 = null;
            var2_2 = this._props;
            var3_3 = this._dbName;
            if (var2_2.getBoolean(6)) {
                try {
                    this.checkMDA(this._pc);
                    if (var2_2.getString(8) == null) {
                        this._protocol.setOption(null, 6, this.getDefaultServerCharset());
                    }
                    this._protocol.setOption(null, 11, false);
                    if (var3_3 == null || var3_3.length() <= 0) ** GOTO lbl122
                    this.setCatalog(var3_3);
                }
                catch (Exception var4_4) {
                    if (var4_4 instanceof SQLException && "JZ0IB".equals(((SQLException)var4_4).getSQLState())) {
                        this.markDead(false);
                        try {
                            try {
                                this._protocol.logout();
                            }
                            catch (SQLException v0) {
                            }
                            var6_7 = null;
                            this._pc.drop();
                        }
                        catch (Throwable var5_15) {
                            var6_8 = null;
                            this._pc.drop();
                            throw var5_15;
                        }
                        var5_16 = (SQLException)var4_4;
                        var6_7 = new SQLException(var5_16.getMessage(), var5_16.getSQLState());
                        throw var6_7;
                    }
                    try {
                        ErrorMessage.raiseWarning("010MX", var4_4.toString());
                    }
                    catch (SQLWarning var5_17) {
                        block53: {
                            try {
                                try {
                                    if (var3_3 != null && var3_3.length() > 0) {
                                        var1_1 = this.createStatement();
                                        var1_1.executeUpdate("use " + var3_3);
                                    }
                                }
                                catch (SQLException var8_21) {
                                    this.handleSQLE(ErrorMessage.createWarning("010UF", var8_21.getMessage()));
                                }
                                var7_27 /* !! */  = null;
                                if (var1_1 == null) break block53;
                            }
                            catch (Throwable var6_9) {
                                var7_28 = null;
                                if (var1_1 != null) {
                                    try {
                                        var1_1.close();
                                        var1_1 = null;
                                    }
                                    catch (SQLException var8_24) {
                                        var1_1 = null;
                                        this.handleSQLE(var8_24);
                                    }
                                    catch (RuntimeException var8_25) {
                                        var1_1 = null;
                                        throw var8_25;
                                    }
                                }
                                this.handleSQLE(var5_17);
                                throw var6_9;
                            }
                            try {
                                var1_1.close();
                                var1_1 = null;
                            }
                            catch (SQLException var8_22) {
                                var1_1 = null;
                                this.handleSQLE(var8_22);
                            }
                            catch (RuntimeException var8_23) {
                                var1_1 = null;
                                throw var8_23;
                            }
                        }
                        this.handleSQLE(var5_17);
                    }
                }
            } else {
                try {
                    try {
                        if (var3_3 != null && var3_3.length() > 0) {
                            var1_1 = this.createStatement();
                            var1_1.executeUpdate("use " + var3_3);
                        }
                    }
                    catch (SQLException var6_10) {
                        this.handleSQLE(ErrorMessage.createWarning("010SK", var6_10.getMessage()));
                    }
                    var5_18 = null;
                    ** if (var1_1 == null) goto lbl-1000
                }
                catch (Throwable var4_5) {
                    var5_19 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                            var1_1 = null;
                        }
                        catch (SQLException var6_13) {
                            var1_1 = null;
                            this.handleSQLE(var6_13);
                        }
                        catch (RuntimeException var6_14) {
                            var1_1 = null;
                            throw var6_14;
                        }
                    }
                    throw var4_5;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                        var1_1 = null;
                    }
                    catch (SQLException var6_11) {
                        var1_1 = null;
                        this.handleSQLE((SQLException)var6_11);
                    }
                    catch (RuntimeException var6_12) {
                        var1_1 = null;
                        throw var6_12;
                    }
                }
lbl-1000:
                // 1 sources

                {
                }
            }
lbl122:
            // 7 sources

            if ((var4_6 = var2_2.getString(18)) != null && var4_6.length() > 0) {
                try {
                    try {
                        var1_1 = this.createStatement();
                        var1_1.executeUpdate(var4_6);
                    }
                    catch (SQLException var7_29) {
                        this.handleSQLE(var7_29);
                    }
                    var6_11 = null;
                    ** if (var1_1 == null) goto lbl-1000
                }
                catch (Throwable var5_20) {
                    var6_11 = null;
                    if (var1_1 != null) {
                        try {
                            var1_1.close();
                            var1_1 = null;
                        }
                        catch (SQLException var7_27 /* !! */ ) {
                            var1_1 = null;
                            this.handleSQLE(var7_27 /* !! */ );
                        }
                        catch (RuntimeException var7_27 /* !! */ ) {
                            var1_1 = null;
                            throw var7_27 /* !! */ ;
                        }
                    }
                    throw var5_20;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var1_1.close();
                        var1_1 = null;
                    }
                    catch (SQLException var7_27 /* !! */ ) {
                        var1_1 = null;
                        this.handleSQLE(var7_27 /* !! */ );
                    }
                    catch (RuntimeException var7_27 /* !! */ ) {
                        var1_1 = null;
                        throw var7_27 /* !! */ ;
                    }
                }
lbl-1000:
                // 1 sources

                {
                }
            }
            this._state = 0;
            var5_18 = (String[])this._props.getObject(38);
            if (var5_18 == null) break block57;
            var6_11 = this._protocol.getClassLoader();
            if (var6_11 == null) {
                ErrorMessage.raiseError("JZ0CL");
            } else {
                try {
                    var6_11.preloadJars(var5_18);
                }
                catch (SQLException var7_30) {
                    this.chainWarnings(var7_30);
                    try {
                        ErrorMessage.raiseWarning("010PF");
                    }
                    catch (SQLWarning var8_26) {
                        this.chainWarnings(var8_26);
                    }
                }
            }
        }
    }

    protected ProtocolContext initProtocol() throws SQLException {
        ProtocolContext protocolContext = this._protocol.getProtocolContext(this._props);
        protocolContext._protocol = this._protocol;
        protocolContext._conn = this;
        if (this._pc != null) {
            protocolContext._msgHandler = this._pc._msgHandler;
        }
        return protocolContext;
    }

    public boolean isClosed() throws SQLException {
        String string = this._props.getString(36);
        if (this._state != 4 && !"INTERNAL".equals(string)) {
            CallableStatement callableStatement = null;
            Statement statement = null;
            try {
                block14: {
                    try {
                        if (string == null) {
                            callableStatement = this.prepareCall("{call sp_mda(?,?)}");
                            callableStatement.setInt(1, 0);
                            callableStatement.setInt(2, 7);
                            callableStatement.executeQuery();
                        } else {
                            statement = this.createStatement();
                            statement.executeQuery(string);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!"JZ0F2".equals(sQLException.getSQLState())) break block14;
                        throw sQLException;
                    }
                }
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                try {
                    if (callableStatement != null) {
                        callableStatement.close();
                        callableStatement = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                    callableStatement = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException sQLException) {}
        }
        return this._state == 4;
    }

    protected boolean isDead() {
        return this._state == 4;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkConnection();
        boolean bl = false;
        try {
            bl = this._protocol.getBoolOption(null, 3);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return bl;
    }

    public void markDead() {
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {}
    }

    public void markDead(boolean bl) throws SQLException {
        this._state = 4;
        if (bl) {
            this.checkConnection();
        }
    }

    public void markDeadTryHA() throws IOException {
        boolean bl = false;
        try {
            bl = this._props.getBoolean(34);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {
            if ("JZ0F2".equals(sQLException.getSQLState())) {
                ErrorMessage.raiseHAException("JZ0F2");
            }
            IOException iOException = new IOException(sQLException.getMessage());
            ErrorMessage.raiseSybConnectionDeadException(iOException);
        }
        if (bl) {
            ErrorMessage.raiseHAException("JZ0F2");
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkConnection();
        SybStatement sybStatement = (SybStatement)this.createStatement();
        return sybStatement.processEscapes(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void nextHAState() {
        if (!this._wasConnected) {
            switch (this._haState) {
                case -1: {
                    this._haState = 0;
                    return;
                }
                case 0: {
                    this._haState = 1;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (this._haState) {
            case 2: {
                this._haState = 4;
                break;
            }
            case 4: 
            case 5: {
                this._haState = 6;
                break;
            }
            case 3: {
                this._haState = 5;
            }
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkConnection();
        SybCallableStatement sybCallableStatement = new SybCallableStatement(this.initProtocol(), string);
        return sybCallableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        SybCallableStatement sybCallableStatement = (SybCallableStatement)this.prepareCall(string);
        sybCallableStatement.setResultSetParams(n, n2);
        return sybCallableStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            return this.prepareStatement(string, this._dynamicPrepare);
        }
        catch (SQLException sQLException) {
            if (this._dynamicPrepare) {
                return this.prepareStatement(string, false);
            }
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        SybPreparedStatement sybPreparedStatement = (SybPreparedStatement)this.prepareStatement(string);
        sybPreparedStatement.setResultSetParams(n, n2);
        return sybPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        this.checkConnection();
        SybPreparedStatement sybPreparedStatement = bl ? new SybPreparedStatement(this.initProtocol(), string, this._dynStmtNum++) : new SybPreparedStatement(this.initProtocol(), string);
        return sybPreparedStatement;
    }

    public void regNoWatch(String string) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.killEventContext(string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void regWatch(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.makeEventContext(string, sybEventHandler, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    private void regularConnect() throws SQLException {
        if (this._dynamicPrepare && this._props.getBoolean(15)) {
            this.handleSQLE(ErrorMessage.createWarning("010PO"));
        }
        this.tryLogin(this._hostPortList);
    }

    public void removeCursorResultSet(String string) {
        if (this._cursors == null) {
            return;
        }
        try {
            this._cursors.remove(string);
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    public void rollback() throws SQLException {
        this.checkConnection();
        try {
            this._protocol.endTransaction(false);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 1, bl);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 9, string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    protected void setHALoginStatus(int n) {
        this._haLoginStatus = n;
    }

    protected void setHAState(int n) {
        this._haState = n;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 3, bl);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._pc.setMessageHandler(sybMessageHandler);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.setOption(null, 2, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        Debug.notImplemented(this, "setTypeMap(java.util.Map)");
    }

    public static boolean thisChainHasAnException(SQLException sQLException) {
        boolean bl = false;
        SQLException sQLException2 = sQLException;
        while (sQLException2 != null) {
            if (!(sQLException2 instanceof SQLWarning)) {
                bl = true;
                break;
            }
            sQLException2 = sQLException2.getNextException();
        }
        return bl;
    }

    private void tryLogin(Vector vector) throws SQLException {
        block11: {
            boolean bl = true;
            boolean bl2 = this._props.getBoolean(26);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    String string;
                    this._currentHostPort = string = (String)enumeration.nextElement();
                    this._protocol.login(string, this._props, this, true);
                    break;
                }
                catch (SQLWarning sQLWarning) {
                    this.chainWarnings(sQLWarning);
                    break;
                }
                catch (SQLException sQLException) {
                    if (bl2 && enumeration.hasMoreElements()) {
                        this.chainWarnings(sQLException);
                        try {
                            ErrorMessage.raiseWarning("010SQ");
                        }
                        catch (SQLWarning sQLWarning) {
                            this.chainWarnings(sQLWarning);
                        }
                        continue;
                    }
                    if (this._props.getBoolean(34) && ("JZ006".equals(sQLException.getSQLState()) || "JZ00L".equals(sQLException.getSQLState())) && this.getHAState() != 1 && this.getHAState() != 6) {
                        this.handleHAFailover();
                        bl = false;
                        break;
                    }
                    if ("JZ0F2".equals(sQLException.getSQLState())) {
                        this.handleSQLE(sQLException);
                        continue;
                    }
                    this.markDead(false);
                    this.handleSQLE(sQLException);
                }
            }
            if (!bl) break block11;
            this._state = 1;
            this._pc = this.initProtocol();
            try {
                this.init();
            }
            catch (SQLWarning sQLWarning) {
                this.chainWarnings(sQLWarning);
            }
        }
    }
}

