/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.soap.util.net.SocketUtils;

public class SSLUtils {
    static /* synthetic */ Class class$javax$net$ssl$SSLSocketFactory;
    static /* synthetic */ Class class$javax$net$ssl$SSLSocket;
    static /* synthetic */ Class class$java$lang$String;

    public static Socket buildSSLSocket(String host, int port, String tunnelHost, int tunnelPort) throws IOException, UnknownHostException, InvocationTargetException {
        return SSLUtils.buildSSLSocket(host, port, 0, tunnelHost, tunnelPort, null, null);
    }

    public static Socket buildSSLSocket(String host, int port, String tunnelHost, int tunnelPort, Boolean tcpNoDelay) throws IOException, UnknownHostException, InvocationTargetException {
        return SSLUtils.buildSSLSocket(host, port, 0, tunnelHost, tunnelPort, null, tcpNoDelay);
    }

    public static Socket buildSSLSocket(String host, int port, String tunnelHost, int tunnelPort, String tunnelAuth, Boolean tcpNoDelay) throws IOException, UnknownHostException, InvocationTargetException {
        return SSLUtils.buildSSLSocket(host, port, 0, tunnelHost, tunnelPort, tunnelAuth, tcpNoDelay);
    }

    public static Socket buildSSLSocket(String host, int port, int timeout, String tunnelHost, int tunnelPort, String tunnelAuth, Boolean tcpNoDelay) throws IOException, UnknownHostException, InvocationTargetException {
        SSLSocket sslSocket = null;
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        if (tunnelHost == null) {
            if (timeout == 0) {
                sslSocket = (SSLSocket)factory.createSocket(host, port);
            } else {
                try {
                    Method createSocket = (class$javax$net$ssl$SSLSocketFactory == null ? (class$javax$net$ssl$SSLSocketFactory = SSLUtils.class$("javax.net.ssl.SSLSocketFactory")) : class$javax$net$ssl$SSLSocketFactory).getMethod("createSocket", new Class[0]);
                    Class<?> socketAddress = Class.forName("java.net.SocketAddress");
                    Method connect = (class$javax$net$ssl$SSLSocket == null ? (class$javax$net$ssl$SSLSocket = SSLUtils.class$("javax.net.ssl.SSLSocket")) : class$javax$net$ssl$SSLSocket).getMethod("connect", socketAddress, Integer.TYPE);
                    Class<?> inetSocketAddress = Class.forName("java.net.InetSocketAddress");
                    Constructor<?> ctor = inetSocketAddress.getConstructor(class$java$lang$String == null ? (class$java$lang$String = SSLUtils.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                    sslSocket = (SSLSocket)createSocket.invoke((Object)factory, new Object[0]);
                    Object address = ctor.newInstance(host, new Integer(port));
                    connect.invoke((Object)sslSocket, address, new Integer(timeout));
                }
                catch (ClassNotFoundException e) {
                    sslSocket = (SSLSocket)factory.createSocket(host, port);
                }
                catch (InstantiationException e) {
                    sslSocket = (SSLSocket)factory.createSocket(host, port);
                }
                catch (NoSuchMethodException e) {
                    sslSocket = (SSLSocket)factory.createSocket(host, port);
                }
                catch (IllegalAccessException e) {
                    sslSocket = (SSLSocket)factory.createSocket(host, port);
                }
            }
        } else {
            Socket tunnel = SSLUtils.doTunnelHandshake(tunnelHost, tunnelPort, tunnelAuth, host, port, timeout, tcpNoDelay);
            sslSocket = (SSLSocket)factory.createSocket(tunnel, host, port, true);
        }
        if (sslSocket != null) {
            if (tcpNoDelay != null) {
                sslSocket.setTcpNoDelay(tcpNoDelay);
            }
            if (timeout > 0) {
                sslSocket.setSoTimeout(timeout);
            }
            sslSocket.startHandshake();
        }
        return sslSocket;
    }

    private static Socket doTunnelHandshake(String tunnelHost, int tunnelPort, String tunnelAuth, String host, int port, int timeout, Boolean tcpNoDelay) throws IOException, InvocationTargetException {
        String replyStr;
        byte[] b;
        Socket tunnel = SocketUtils.createSocket(tunnelHost, tunnelPort, timeout);
        if (tcpNoDelay != null) {
            tunnel.setTcpNoDelay(tcpNoDelay);
        }
        if (timeout > 0) {
            tunnel.setSoTimeout(timeout);
        }
        OutputStream out = tunnel.getOutputStream();
        String msg = tunnelAuth == null ? "CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "User-Agent: Apache SOAP" + "\r\n\r\n" : "CONNECT " + host + ":" + port + " HTTP/1.0\r\n" + "Proxy-Authorization: " + tunnelAuth + "\r\n" + "User-Agent: Apache SOAP" + "\r\n\r\n";
        try {
            b = msg.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = msg.getBytes();
        }
        out.write(b);
        out.flush();
        byte[] reply = new byte[200];
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = tunnel.getInputStream();
        boolean error = false;
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (i == 10) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        StringTokenizer st = new StringTokenizer(replyStr);
        st.nextToken();
        if (!st.nextToken().startsWith("200")) {
            throw new IOException("Unable to tunnel through " + tunnelHost + ":" + tunnelPort + ".  Proxy returns \"" + replyStr + "\"");
        }
        return tunnel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

