/*
 * Decompiled with CFR 0.152.
 */
package org.aton.system;

import org.aton.logger.FileLogger;
import org.aton.logger.ILogger;

public class SystemGC {
    public static final int GCTIMES_MAX = 3;
    public static final int GCWAIT_TIME = 200;
    private int m_nThreshold = 100;
    private int m_nDangerLine = 50;
    private int m_nMaxFailTimes = 20;
    private long m_nWaitTimeAfterGC = 100L;
    private int m_nFailTimes = 0;
    private int m_nLastFreeMemory = 0;
    private ILogger m_logger = new FileLogger("SystemGC.logger");
    private static SystemGC m_instance = new SystemGC();

    protected SystemGC() {
        ((FileLogger)this.m_logger).setPrefix("systemgc_");
    }

    public void finalize() {
        this.close();
    }

    public static final synchronized SystemGC getInstance() {
        return m_instance;
    }

    public void close() {
        if (this.m_logger != null) {
            this.m_logger.close();
        }
    }

    public static final int gc(int _nMaxTimes) {
        int nMaxTimes = _nMaxTimes <= 0 ? 1 : _nMaxTimes;
        Runtime currRuntime = Runtime.getRuntime();
        int nLastMemory = 0;
        int nFreeMemory = 0;
        int nTimes = 0;
        do {
            System.runFinalization();
            System.gc();
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nLastMemory = nFreeMemory;
            nFreeMemory = (int)(currRuntime.freeMemory() / 1024L / 1024L);
        } while (++nTimes < nMaxTimes && nFreeMemory != nLastMemory);
        return nFreeMemory;
    }

    public int getThreshold() {
        return this.m_nThreshold;
    }

    public void setThreshold(int p_nThreshold) {
        this.m_nThreshold = p_nThreshold <= 0 ? 0 : p_nThreshold;
    }

    public int getDangerLine() {
        return this.m_nDangerLine;
    }

    public void setDangerLine(int p_nDangerLine) {
        this.m_nDangerLine = p_nDangerLine <= 0 ? 0 : p_nDangerLine;
    }

    public int getMaxFailTimes() {
        return this.m_nMaxFailTimes;
    }

    public void setMaxFailTimes(int p_nMaxFailTimes) {
        this.m_nMaxFailTimes = p_nMaxFailTimes;
    }

    public long getWaitTimeAfterGC() {
        return this.m_nWaitTimeAfterGC;
    }

    public void setWaitTimeAfterGC(long p_lTime) {
        this.m_nWaitTimeAfterGC = p_lTime <= 0L ? 0L : p_lTime;
    }

    public int getLastFreeMemory() {
        return this.m_nLastFreeMemory;
    }

    public int getFailTimes() {
        return this.m_nFailTimes;
    }

    public ILogger getLogger() {
        return this.m_logger;
    }

    public ILogger setLogger(ILogger p_logger) {
        ILogger loggerOld = this.m_logger;
        if (this.m_logger != null) {
            this.m_logger.close();
        }
        this.m_logger = p_logger;
        return loggerOld;
    }

    public boolean insureSufficientMemory(int p_nMinSize, int p_nMaxGCTimes) {
        if (p_nMinSize <= 0) {
            return true;
        }
        Runtime runtime = Runtime.getRuntime();
        this.m_nLastFreeMemory = (int)runtime.freeMemory() / 1024 / 1024;
        if (this.m_nLastFreeMemory >= p_nMinSize) {
            if (this.m_nFailTimes > 0) {
                this.m_nFailTimes = 0;
            }
            return true;
        }
        if (this.m_nFailTimes >= this.m_nMaxFailTimes) {
            return false;
        }
        int nTimes = 0;
        int nFreeMemory = 0;
        do {
            System.runFinalization();
            System.gc();
            ++nTimes;
            if (this.m_nWaitTimeAfterGC <= 0L) continue;
            try {
                Thread.sleep(this.m_nWaitTimeAfterGC);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while ((nFreeMemory = (int)runtime.freeMemory() / 1024 / 1024) < p_nMinSize && nTimes < p_nMaxGCTimes);
        if (this.m_logger != null) {
            this.m_logger.log("[" + this.m_nFailTimes + "] GC: " + this.m_nLastFreeMemory + "->" + nFreeMemory + "M/" + (int)(runtime.totalMemory() / 1024L / 1024L) + "M; T: " + nTimes, 4);
        }
        this.m_nLastFreeMemory = nFreeMemory;
        if (nFreeMemory >= p_nMinSize) {
            if (this.m_nFailTimes > 0) {
                this.m_nFailTimes = 0;
            }
            return true;
        }
        ++this.m_nFailTimes;
        return false;
    }

    public boolean insureSufficientMemory(int p_nMaxGCTimes) {
        return this.insureSufficientMemory(this.m_nThreshold, p_nMaxGCTimes);
    }

    public boolean insureSufficientMemory() {
        return this.insureSufficientMemory(this.m_nThreshold, 3);
    }

    public static void main(String[] args) {
        SystemGC systemGC = SystemGC.getInstance();
        systemGC.setThreshold(30);
        StringBuffer buffer = null;
        int i = 0;
        while (i < 100) {
            buffer = new StringBuffer(1000);
            buffer.append("123456789012345678901234567890");
            buffer = null;
            ++i;
        }
        i = 0;
        while (i < 100) {
            systemGC.insureSufficientMemory();
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        systemGC.close();
    }
}

